/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.commandswitch.CommandSwitch;
import io.github.gaming32.bingo.data.BingoDifficulties;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.data.goal.GoalManager;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.game.BoardShape;
import io.github.gaming32.bingo.game.InvalidGoalException;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import io.github.gaming32.bingo.network.messages.s2c.RemoveBoardPayload;
import io.github.gaming32.bingo.util.Vec2i;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.scores.PlayerTeam;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class BingoCommand {
    private static final SimpleCommandExceptionType NO_GAME_RUNNING = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.no_game_running", new Object[0]));
    private static final DynamicCommandExceptionType INVALID_SHAPE = new DynamicCommandExceptionType(shape -> Bingo.translatableEscape("bingo.invalid_shape", shape));
    private static final Dynamic3CommandExceptionType INVALID_SIZE = new Dynamic3CommandExceptionType((size, min, max) -> Bingo.translatableEscape("bingo.invalid_size", size, min, max));
    private static final DynamicCommandExceptionType CANNOT_SHOW_BOARD = new DynamicCommandExceptionType(size -> Bingo.translatableEscape("bingo.cannot_show_board", size));
    private static final DynamicCommandExceptionType TEAM_ALREADY_EXISTS = new DynamicCommandExceptionType(team -> Bingo.translatableEscape("bingo.team_already_exists", ((PlayerTeam)team).getFormattedDisplayName()));
    private static final DynamicCommandExceptionType DUPLICATE_TEAMS = new DynamicCommandExceptionType(team -> Bingo.translatableEscape("bingo.duplicate_teams", ((PlayerTeam)team).getFormattedDisplayName()));
    private static final DynamicCommandExceptionType UNKNOWN_DIFFICULTY = new DynamicCommandExceptionType(difficultyId -> Bingo.translatableEscape("bingo.unknown_difficulty", difficultyId));
    private static final DynamicCommandExceptionType UNKNOWN_GOAL = new DynamicCommandExceptionType(goalId -> Bingo.translatableEscape("bingo.unknown_goal", goalId));
    private static final DynamicCommandExceptionType UNKNOWN_TAG = new DynamicCommandExceptionType(tagId -> Bingo.translatableEscape("bingo.unknown_tag", tagId));
    private static final DynamicCommandExceptionType UNKNOWN_GAMEMODE = new DynamicCommandExceptionType(gamemodeId -> Bingo.translatableEscape("bingo.unknown_gamemode", gamemodeId));
    private static final DynamicCommandExceptionType INVALID_GOAL = new DynamicCommandExceptionType(e -> Bingo.translatable("bingo.start.invalid_goal", new Object[0]).withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText(Component.nullToEmpty((String)((InvalidGoalException)e).getMessage())))));
    private static final DynamicCommandExceptionType FAILED_TO_START = new DynamicCommandExceptionType(e -> Bingo.translatable("bingo.start.failed", new Object[0]).withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText(Component.nullToEmpty((String)((Throwable)e).getMessage())))));
    private static final SimpleCommandExceptionType NO_TEAMS = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.no_teams", new Object[0]));
    private static final SimpleCommandExceptionType NOT_IN_TEAM = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.not_in_team", new Object[0]));
    private static final SimpleCommandExceptionType FORFEIT_ALREADY_FINISHED = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.forfeit.already_finished", new Object[0]));
    private static final DynamicCommandExceptionType TEAM_NOT_PLAYING = new DynamicCommandExceptionType(team -> Bingo.translatableEscape("bingo.team_not_playing", team));
    private static final SimpleCommandExceptionType ALREADY_NERFED = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.already_nerfed", new Object[0]));
    private static final SimpleCommandExceptionType NOT_NERFED = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.not_nerfed", new Object[0]));
    private static final SuggestionProvider<CommandSourceStack> ACTIVE_GOAL_SUGGESTOR = (context, builder) -> {
        BingoGame game = ((MinecraftServerExt)((CommandSourceStack)context.getSource()).getServer()).bingo$getGame();
        if (game == null) {
            return builder.buildFuture();
        }
        return SharedSuggestionProvider.suggestResource(Arrays.stream(game.getBoard().getGoals()).map(ActiveGoal::id), (SuggestionsBuilder)builder);
    };
    private static final CommandSwitch<Boolean> REQUIRE_CLIENT = CommandSwitch.storeTrue("--require-client");
    private static final CommandSwitch<Boolean> CONTINUE_AFTER_WIN = CommandSwitch.storeTrue("--continue-after-win");
    private static final CommandSwitch<Boolean> INCLUDE_INACTIVE_TEAMS = CommandSwitch.storeTrue("--include-inactive-teams");
    private static final CommandSwitch<String> SHAPE = CommandSwitch.argument("--shape", StringArgumentType.word()).suggests((SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(ctx, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(BoardShape.values()).map(BoardShape::getSerializedName), (SuggestionsBuilder)builder))).build(BoardShape.SQUARE.getSerializedName());
    private static final CommandSwitch<Integer> SIZE = CommandSwitch.argument("--size", IntegerArgumentType.integer()).build(5);
    private static final CommandSwitch<Long> SEED = CommandSwitch.argument("--seed", LongArgumentType.longArg()).build((Long)((Object)((Supplier<Long>)RandomSupport::generateUniqueSeed)));
    private static final CommandSwitch<Integer> AUTO_FORFEIT_TIME = CommandSwitch.argument("--auto-forfeit-time", TimeArgument.time((int)0)).getter(IntegerArgumentType::getInteger).build(2400);
    private static final CommandSwitch<Holder.Reference<BingoDifficulty>> DIFFICULTY = CommandSwitch.resource("--difficulty", BingoRegistries.DIFFICULTY).unknownExceptionType(UNKNOWN_DIFFICULTY).build(BingoDifficulties.MEDIUM);
    private static final CommandSwitch<Holder.Reference<BingoGameMode>> GAMEMODE = CommandSwitch.resource("--gamemode", BingoRegistries.GAME_MODE).unknownExceptionType(UNKNOWN_GAMEMODE).build(BingoGameMode.STANDARD.key());
    private static final CommandSwitch<Set<GoalHolder>> REQUIRE_GOAL = CommandSwitch.specialArgument("--require-goal", ResourceKeyArgument.key(BingoRegistries.GOAL)).getter((context, arg) -> {
        ResourceKey key = ResourceKeyArgument.getRegistryKey((CommandContext)context, (String)arg, BingoRegistries.GOAL, (DynamicCommandExceptionType)INVALID_GOAL);
        GoalHolder goal = GoalManager.getGoal(key.location());
        if (goal == null) {
            throw UNKNOWN_GOAL.create((Object)key.location());
        }
        return goal;
    }).buildRepeatable(LinkedHashSet::new);
    private static final CommandSwitch<HolderSet<BingoTag>> EXCLUDE_TAG = CommandSwitch.resource("--exclude-tag", BingoRegistries.TAG).unknownExceptionType(UNKNOWN_TAG).buildRepeatable();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection selection) {
        LiteralCommandNode bingoCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bingo").then(Commands.literal((String)"start").requires(source -> source.hasPermission(2)))).then(((LiteralArgumentBuilder)Commands.literal((String)"stop").requires(source -> source.hasPermission(2) && ((MinecraftServerExt)source.getServer()).bingo$getGame() != null)).executes(ctx -> {
            BingoGame game = ((MinecraftServerExt)((CommandSourceStack)ctx.getSource()).getServer()).bingo$getGame();
            if (game == null) {
                throw NO_GAME_RUNNING.create();
            }
            game.endGame(((CommandSourceStack)ctx.getSource()).getServer().getPlayerList());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(source -> source.hasPermission(2))).executes(BingoCommand::resetGame))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"forfeit").requires(source -> ((MinecraftServerExt)source.getServer()).bingo$getGame() != null)).executes(ctx -> BingoCommand.forfeit((CommandSourceStack)ctx.getSource()))).then(((RequiredArgumentBuilder)Commands.argument((String)"team", (ArgumentType)TeamArgument.team()).requires(source -> source.hasPermission(2) && ((MinecraftServerExt)source.getServer()).bingo$getGame() != null)).executes(ctx -> BingoCommand.forfeit((CommandSourceStack)ctx.getSource(), TeamArgument.getTeam((CommandContext)ctx, (String)"team")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"board").requires(source -> ((MinecraftServerExt)source.getServer()).bingo$getGame() != null)).executes(ctx -> {
            final BingoGame game = ((MinecraftServerExt)((CommandSourceStack)ctx.getSource()).getServer()).bingo$getGame();
            if (game == null) {
                throw NO_GAME_RUNNING.create();
            }
            final int size = game.getBoard().getSize();
            final Vec2i visualSize = game.getBoard().getShape().getVisualSize(size);
            if (visualSize.x() > 9) {
                throw CANNOT_SHOW_BOARD.create((Object)size);
            }
            final MenuType menuType = switch (visualSize.y()) {
                case 1 -> MenuType.GENERIC_9x1;
                case 2 -> MenuType.GENERIC_9x2;
                case 3 -> MenuType.GENERIC_9x3;
                case 4 -> MenuType.GENERIC_9x4;
                case 5 -> MenuType.GENERIC_9x5;
                case 6 -> MenuType.GENERIC_9x6;
                default -> throw CANNOT_SHOW_BOARD.create((Object)size);
            };
            final RegistryAccess registries = ((CommandSourceStack)ctx.getSource()).registryAccess();
            ((CommandSourceStack)ctx.getSource()).getPlayerOrException().openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
                    ChestMenu menu = new ChestMenu(this, menuType, syncId, inventory, (Container)new SimpleContainer(9 * visualSize.y()), visualSize.y()){

                        public void clicked(int slotId, int button, ClickType clickType, Player player) {
                            this.sendAllDataToRemote();
                        }
                    };
                    int minX = (9 - visualSize.x()) / 2;
                    for (int goalIndex = 0; goalIndex < game.getBoard().getGoals().length; ++goalIndex) {
                        Vec2i goalPos = game.getBoard().getShape().getCoords(size, goalIndex);
                        menu.getContainer().setItem(minX + goalPos.y() * 9 + goalPos.x(), game.getBoard().getGoals()[goalIndex].getFallbackWithComponents(registries));
                    }
                    return menu;
                }

                @NotNull
                public Component getDisplayName() {
                    return Bingo.translatable("bingo.board.title", new Object[0]);
                }
            });
            return 1;
        })).then(Commands.literal((String)"copy").executes(ctx -> {
            BingoGame game = ((MinecraftServerExt)((CommandSourceStack)ctx.getSource()).getServer()).bingo$getGame();
            if (game == null) {
                throw NO_GAME_RUNNING.create();
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> ComponentUtils.wrapInSquareBrackets((Component)Bingo.translatable("bingo.board.copy", new Object[0])).withStyle(s -> s.withColor(ChatFormatting.GREEN).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Bingo.translatable("chat.copy.click", new Object[0]))).withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(game.getBoard().toString()))), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"difficulties").requires(source -> source.hasPermission(2))).executes(ctx -> {
            BingoGame game = ((MinecraftServerExt)((CommandSourceStack)ctx.getSource()).getServer()).bingo$getGame();
            if (game == null) {
                throw NO_GAME_RUNNING.create();
            }
            BingoBoard board = game.getBoard();
            Vec2i visualSize = board.getShape().getVisualSize(board.getSize());
            StringBuilder line = new StringBuilder(visualSize.x());
            for (int y = 0; y < visualSize.y(); ++y) {
                for (int x = 0; x < visualSize.x(); ++x) {
                    int goalIndex = board.getShape().getCellFromCoords(board.getSize(), x, y);
                    if (goalIndex == -1) {
                        line.append(' ');
                        continue;
                    }
                    line.append(((BingoDifficulty)board.getGoals()[goalIndex].difficulty().orElseThrow().value()).number());
                }
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)line.toString()), false);
                line.setLength(0);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"goals").requires(source -> source.hasPermission(2) && ((MinecraftServerExt)source.getServer()).bingo$getGame() != null)).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"award").then(Commands.argument((String)"goal", (ArgumentType)ResourceLocationArgument.id()).suggests(ACTIVE_GOAL_SUGGESTOR).executes(ctx -> BingoCommand.awardOrRevoke((CommandContext<CommandSourceStack>)ctx, (TriFunction<BingoGame, ServerPlayer, ActiveGoal, Boolean>)((TriFunction)BingoGame::award), "bingo.award.success"))))).then(Commands.literal((String)"revoke").then(Commands.argument((String)"goal", (ArgumentType)ResourceLocationArgument.id()).suggests(ACTIVE_GOAL_SUGGESTOR).executes(ctx -> BingoCommand.awardOrRevoke((CommandContext<CommandSourceStack>)ctx, (TriFunction<BingoGame, ServerPlayer, ActiveGoal, Boolean>)((TriFunction)BingoGame::revoke), "bingo.revoke.success"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"teams").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"create").then(Commands.argument((String)"color", (ArgumentType)ColorArgument.color()).suggests((context, builder) -> {
            ServerScoreboard scoreboard = ((CommandSourceStack)context.getSource()).getServer().getScoreboard();
            return SharedSuggestionProvider.suggest(ChatFormatting.getNames((boolean)true, (boolean)false).stream().filter(n -> scoreboard.getPlayerTeam(n) == null), (SuggestionsBuilder)builder);
        }).executes(context -> {
            ChatFormatting color = ColorArgument.getColor((CommandContext)context, (String)"color");
            String name = color.getName();
            ServerScoreboard scoreboard = ((CommandSourceStack)context.getSource()).getServer().getScoreboard();
            PlayerTeam existing = scoreboard.getPlayerTeam(name);
            if (existing != null) {
                throw TEAM_ALREADY_EXISTS.create((Object)existing);
            }
            PlayerTeam team = scoreboard.addPlayerTeam(name);
            team.setColor(color);
            team.setDisplayName((Component)Bingo.translatable("bingo.formatting." + name, new Object[0]));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Bingo.translatable("bingo.created_team", team.getFormattedDisplayName()), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"randomize").executes(context -> BingoCommand.randomizeTeams((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers().stream().filter(p -> !p.isSpectator()).toList(), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> BingoCommand.randomizeTeams((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"players"), null))).then(Commands.argument((String)"groups", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> BingoCommand.randomizeTeams((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"players"), IntegerArgumentType.getInteger((CommandContext)context, (String)"groups")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"nerf").then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            if (!Bingo.CONFIG.getNerfedPlayers().add(player.getUUID())) {
                throw ALREADY_NERFED.create();
            }
            Bingo.CONFIG.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Bingo.translatable("bingo.nerf.added", player.getDisplayName()), true);
            return 1;
        })))).then(Commands.literal((String)"remove").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            if (!Bingo.CONFIG.getNerfedPlayers().remove(player.getUUID())) {
                throw NOT_NERFED.create();
            }
            Bingo.CONFIG.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Bingo.translatable("bingo.nerf.removed", player.getDisplayName()), true);
            return 1;
        })))));
        CommandNode startCommand = bingoCommand.getChild("start");
        REQUIRE_CLIENT.addTo((CommandNode<CommandSourceStack>)startCommand);
        CONTINUE_AFTER_WIN.addTo((CommandNode<CommandSourceStack>)startCommand);
        INCLUDE_INACTIVE_TEAMS.addTo((CommandNode<CommandSourceStack>)startCommand);
        SHAPE.addTo((CommandNode<CommandSourceStack>)startCommand);
        SIZE.addTo((CommandNode<CommandSourceStack>)startCommand);
        SEED.addTo((CommandNode<CommandSourceStack>)startCommand);
        AUTO_FORFEIT_TIME.addTo((CommandNode<CommandSourceStack>)startCommand);
        DIFFICULTY.addTo((CommandNode<CommandSourceStack>)startCommand);
        GAMEMODE.addTo((CommandNode<CommandSourceStack>)startCommand);
        REQUIRE_GOAL.addTo((CommandNode<CommandSourceStack>)startCommand);
        EXCLUDE_TAG.addTo((CommandNode<CommandSourceStack>)startCommand);
        CommandNode currentCommand = startCommand;
        for (int i = 1; i <= 32; ++i) {
            int teamCount = i;
            ArgumentCommandNode subCommand = ((RequiredArgumentBuilder)Commands.argument((String)("team" + i), (ArgumentType)TeamArgument.team()).executes(context -> BingoCommand.startGame((CommandContext<CommandSourceStack>)context, teamCount))).build();
            currentCommand.addChild((CommandNode)subCommand);
            currentCommand = subCommand;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int startGame(CommandContext<CommandSourceStack> context, int teamCount) throws CommandSyntaxException {
        server = ((CommandSourceStack)context.getSource()).getServer();
        playerList = server.getPlayerList();
        existingGame = ((MinecraftServerExt)server).bingo$getGame();
        if (existingGame != null) {
            existingGame.endGame(playerList);
        }
        registries = ((CommandSourceStack)context.getSource()).registryAccess();
        difficulty = BingoCommand.DIFFICULTY.get(context);
        seed = BingoCommand.SEED.get(context);
        requiredGoals = BingoCommand.REQUIRE_GOAL.get(context);
        excludedTags = BingoCommand.EXCLUDE_TAG.get(context);
        shapeString = BingoCommand.SHAPE.get(context);
        shape = (BoardShape)BoardShape.CODEC.parse((DynamicOps)JavaOps.INSTANCE, (Object)shapeString).getOrThrow((Function<String, CommandSyntaxException>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$startGame$50(java.lang.String java.lang.String ), (Ljava/lang/String;)Lcom/mojang/brigadier/exceptions/CommandSyntaxException;)((String)shapeString));
        size = BingoCommand.SIZE.get(context);
        if (size < shape.getMinSize() || size > shape.getMaxSize()) {
            throw BingoCommand.INVALID_SIZE.create((Object)size, (Object)shape.getMinSize(), (Object)shape.getMaxSize());
        }
        gamemode = (BingoGameMode)BingoCommand.GAMEMODE.get(context).value();
        requireClient = BingoCommand.REQUIRE_CLIENT.get(context);
        continueAfterWin = BingoCommand.CONTINUE_AFTER_WIN.get(context);
        includeInactiveTeams = BingoCommand.INCLUDE_INACTIVE_TEAMS.get(context);
        autoForfeitTicks = BingoCommand.AUTO_FORFEIT_TIME.get(context);
        teams = LinkedHashSet.newLinkedHashSet(teamCount);
        for (i = 1; i <= teamCount; ++i) {
            argName = "team" + i;
            team = TeamArgument.getTeam(context, (String)argName);
            if (includeInactiveTeams) ** GOTO lbl-1000
            if (playerList.getPlayers().stream().map((Function<ServerPlayer, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getScoreboardName(), (Lnet/minecraft/server/level/ServerPlayer;)Ljava/lang/String;)()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)((Collection)team.getPlayers()))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = teamActive = false;
            }
            if (!teamActive || teams.add(team)) continue;
            throw BingoCommand.DUPLICATE_TEAMS.create((Object)team);
        }
        if (teams.isEmpty()) {
            throw BingoCommand.NO_TEAMS.create();
        }
        configError = gamemode.checkAllowedConfig(new BingoGameMode.GameConfig(gamemode, size, teams));
        if (configError != null) {
            throw configError;
        }
        try {
            board = BingoBoard.generate(shape, size, ((BingoDifficulty)difficulty.value()).number(), teams.size(), RandomSource.create((long)seed), (Predicate<GoalHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isGoalAllowed(io.github.gaming32.bingo.data.goal.GoalHolder ), (Lio/github/gaming32/bingo/data/goal/GoalHolder;)Z)((BingoGameMode)gamemode), requiredGoals, excludedTags, requireClient, (HolderLookup.Provider)registries);
        }
        catch (InvalidGoalException e) {
            Bingo.LOGGER.error("Invalid goal encountered generating Bingo board", (Throwable)e);
            throw BingoCommand.INVALID_GOAL.create((Object)e);
        }
        catch (Exception e) {
            Bingo.LOGGER.error("Error generating Bingo board", (Throwable)e);
            throw BingoCommand.FAILED_TO_START.create((Object)e);
        }
        Bingo.LOGGER.info("Generated board (seed {}):\n{}", (Object)seed, (Object)board);
        game = new BingoGame(board, gamemode, requireClient, continueAfterWin, autoForfeitTicks, (PlayerTeam[])teams.toArray((IntFunction<PlayerTeam[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$startGame$51(int ), (I)[Lnet/minecraft/world/scores/PlayerTeam;)()));
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
            if (!Bingo.CONFIG.getNerfedPlayers().contains(player.getUUID())) continue;
            game.nerfPlayer(player);
        }
        ((MinecraftServerExt)server).bingo$setGame(game);
        Bingo.updateCommandTree(playerList);
        new ArrayList<ServerPlayer>(playerList.getPlayers()).forEach((Consumer<ServerPlayer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addPlayer(net.minecraft.server.level.ServerPlayer ), (Lnet/minecraft/server/level/ServerPlayer;)V)((BingoGame)game));
        playerList.broadcastSystemMessage((Component)Bingo.translatable("bingo.started", new Object[]{((BingoDifficulty)difficulty.value()).description()}), false);
        return 1;
    }

    private static int resetGame(CommandContext<CommandSourceStack> context) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        BingoGame game = ((MinecraftServerExt)server).bingo$getGame();
        if (game != null) {
            game.endGame(server.getPlayerList());
        }
        RemoveBoardPayload.INSTANCE.sendTo(server.getPlayerList().getPlayers());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Bingo.translatable("bingo.reset.success", new Object[0]), true);
        return 1;
    }

    private static int forfeit(CommandSourceStack source) throws CommandSyntaxException {
        BingoGame game = ((MinecraftServerExt)source.getServer()).bingo$getGame();
        if (game == null) {
            throw NO_GAME_RUNNING.create();
        }
        ServerPlayer player = source.getPlayerOrException();
        BingoBoard.Teams team = game.getTeam(player);
        if (!team.any()) {
            throw NOT_IN_TEAM.create();
        }
        if (game.forfeit(source.getServer().getPlayerList(), team)) {
            source.sendSuccess(() -> Bingo.translatable("bingo.forfeit.success", new Object[0]), false);
            return 1;
        }
        throw FORFEIT_ALREADY_FINISHED.create();
    }

    private static int forfeit(CommandSourceStack source, PlayerTeam team) throws CommandSyntaxException {
        BingoGame game = ((MinecraftServerExt)source.getServer()).bingo$getGame();
        if (game == null) {
            throw NO_GAME_RUNNING.create();
        }
        int teamIndex = ArrayUtils.indexOf((Object[])game.getTeams(), (Object)team);
        if (teamIndex == -1) {
            throw TEAM_NOT_PLAYING.create((Object)team.getFormattedDisplayName());
        }
        if (game.forfeit(source.getServer().getPlayerList(), BingoBoard.Teams.fromOne(teamIndex))) {
            source.sendSuccess(() -> Bingo.translatable("bingo.forfeit.success.team", team.getFormattedDisplayName()), true);
            return 1;
        }
        throw FORFEIT_ALREADY_FINISHED.create();
    }

    private static int awardOrRevoke(CommandContext<CommandSourceStack> context, TriFunction<BingoGame, ServerPlayer, ActiveGoal, Boolean> action, @Translatable String resultKey) throws CommandSyntaxException {
        BingoGame game = ((MinecraftServerExt)((CommandSourceStack)context.getSource()).getServer()).bingo$getGame();
        if (game == null) {
            throw NO_GAME_RUNNING.create();
        }
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        ResourceLocation goalId = ResourceLocationArgument.getId(context, (String)"goal");
        int success = 0;
        for (ActiveGoal goal : game.getBoard().getGoals()) {
            if (!goal.id().equals((Object)goalId)) continue;
            for (ServerPlayer player : players) {
                if (!((Boolean)action.apply((Object)game, (Object)player, (Object)goal)).booleanValue()) continue;
                ++success;
            }
        }
        int fSuccess = success;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Bingo.translatable(resultKey, players.size(), fSuccess), true);
        return success;
    }

    private static int randomizeTeams(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, Integer groupCount) throws CommandSyntaxException {
        ServerScoreboard scoreboard = ((CommandSourceStack)context.getSource()).getServer().getScoreboard();
        ArrayList teams = new ArrayList(scoreboard.getPlayerTeams());
        Collections.shuffle(teams);
        if (groupCount != null && groupCount < teams.size()) {
            teams.subList(groupCount, teams.size()).clear();
        }
        if (teams.isEmpty()) {
            throw NO_TEAMS.create();
        }
        ArrayList<ServerPlayer> playerList = new ArrayList<ServerPlayer>(players);
        Collections.shuffle(playerList);
        for (int i = 0; i < playerList.size(); ++i) {
            scoreboard.addPlayerToTeam(((ServerPlayer)playerList.get(i)).getScoreboardName(), (PlayerTeam)teams.get(i % teams.size()));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Bingo.translatable("bingo.added_to_teams", players.size(), Math.min(players.size(), teams.size())), true);
        return players.size();
    }

    private static /* synthetic */ PlayerTeam[] lambda$startGame$51(int x$0) {
        return new PlayerTeam[x$0];
    }

    private static /* synthetic */ CommandSyntaxException lambda$startGame$50(String shapeString, String err) {
        return INVALID_SHAPE.create((Object)shapeString);
    }
}

