/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.client.BingoMousePos;
import io.github.gaming32.bingo.client.BoardScreen;
import io.github.gaming32.bingo.client.ClientGame;
import io.github.gaming32.bingo.client.ClientIconTooltip;
import io.github.gaming32.bingo.client.ClientPayloadHandlerImpl;
import io.github.gaming32.bingo.client.IconTooltip;
import io.github.gaming32.bingo.client.PositionAndScale;
import io.github.gaming32.bingo.client.TooltipBuilder;
import io.github.gaming32.bingo.client.config.BingoClientConfig;
import io.github.gaming32.bingo.client.icons.DefaultIconRenderers;
import io.github.gaming32.bingo.client.icons.IconRenderer;
import io.github.gaming32.bingo.client.icons.IconRenderers;
import io.github.gaming32.bingo.client.icons.pip.BlockPictureInPictureRenderState;
import io.github.gaming32.bingo.client.icons.pip.BlockPictureInPictureRenderer;
import io.github.gaming32.bingo.client.recipeviewer.RecipeViewerPlugin;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.GoalProgress;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import io.github.gaming32.bingo.network.ClientPayloadHandler;
import io.github.gaming32.bingo.network.messages.both.ManualHighlightPayload;
import io.github.gaming32.bingo.platform.BingoPlatform;
import io.github.gaming32.bingo.platform.event.ClientEvents;
import io.github.gaming32.bingo.platform.registrar.KeyMappingBuilder;
import io.github.gaming32.bingo.util.ResourceLocations;
import io.github.gaming32.bingo.util.Vec2i;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;

public class BingoClient {
    private static final ResourceLocation BOARD_TEXTURE = ResourceLocations.bingo("board");
    private static final ResourceLocation BOARD_CELL_TEXTURE = ResourceLocations.bingo("board_cell");
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK_SPRITE = ResourceLocations.minecraft("container/slot_highlight_back");
    private static final ResourceLocation SLOT_HIGHLIGHT_FRONT_SPRITE = ResourceLocations.minecraft("container/slot_highlight_front");
    public static final Component BOARD_TITLE = Component.translatable((String)"bingo.board.title");
    public static final Component BOARD_TITLE_SHORT = Component.translatable((String)"bingo.board.title.short");
    public static final int BOARD_OFFSET = 3;
    public static KeyMapping manualHighlightKeyMapping;
    public static BingoBoard.Teams clientTeam;
    public static BingoBoard.Teams receivedClientTeam;
    public static ClientGame clientGame;
    public static final BingoClientConfig CONFIG;
    private static RecipeViewerPlugin recipeViewerPlugin;

    public static void init() {
        CONFIG.load();
        CONFIG.save();
        BingoClient.registerEventHandlers();
        DefaultIconRenderers.setup();
        BingoPlatform.platform.registerKeyMappings(builder -> {
            KeyMapping.Category category = builder.registerCategory(ResourceLocations.bingo("category"));
            builder.name("bingo.key.board").category(category).keyCode(66).conflictContext(KeyMappingBuilder.ConflictContext.IN_GAME).register(minecraft -> {
                if (clientGame != null) {
                    minecraft.setScreen((Screen)new BoardScreen());
                }
            });
            manualHighlightKeyMapping = builder.name("bingo.key.manual_highlight").category(category).keyType(InputConstants.Type.MOUSE).keyCode(0).conflictContext(KeyMappingBuilder.ConflictContext.UNIVERSAL).register(minecraft -> {}).mapping();
        });
        BingoPlatform.platform.registerClientTooltips(registrar -> registrar.register(IconTooltip.class, ClientIconTooltip::new));
        BingoPlatform.platform.registerPictureInPictureRenderers(registrar -> registrar.register(BlockPictureInPictureRenderState.class, BlockPictureInPictureRenderer::new));
        ClientPayloadHandler.init(new ClientPayloadHandlerImpl());
        Bingo.LOGGER.info("Bongo");
    }

    private static void registerEventHandlers() {
        ClientEvents.KEY_RELEASED_PRE.register((screen, event) -> {
            if (clientGame == null || !(screen instanceof ChatScreen)) {
                return false;
            }
            return BingoClient.detectPress(event, BingoClient.getBoardPosition());
        });
        ClientEvents.MOUSE_RELEASED_PRE.register((screen, event) -> {
            if (clientGame == null || !(screen instanceof ChatScreen)) {
                return false;
            }
            return BingoClient.detectClick(event.button(), BingoClient.getBoardPosition());
        });
        ClientEvents.PLAYER_QUIT.register(player -> {
            clientTeam = receivedClientTeam = BingoBoard.Teams.NONE;
            clientGame = null;
        });
        ClientEvents.CLIENT_TICK_END.register(minecraft -> {
            if (minecraft.player == null || !minecraft.player.isSpectator()) {
                clientTeam = receivedClientTeam;
            } else if (minecraft.player.isSpectator() && !clientTeam.any()) {
                clientTeam = BingoBoard.Teams.TEAM1;
            }
        });
    }

    public static PositionAndScale getBoardPosition() {
        Window window = Minecraft.getInstance().getWindow();
        float scale = CONFIG.getBoardScale();
        float x = CONFIG.getBoardCorner().getX(window.getGuiScaledWidth(), scale);
        float y = CONFIG.getBoardCorner().getY(window.getGuiScaledHeight(), scale);
        return new PositionAndScale(x, y, scale);
    }

    public static RecipeViewerPlugin getRecipeViewerPlugin() {
        if (recipeViewerPlugin == null) {
            recipeViewerPlugin = RecipeViewerPlugin.detect();
        }
        return recipeViewerPlugin;
    }

    public static void renderBoardOnHud(Minecraft minecraft, GuiGraphics graphics) {
        if (clientGame == null) {
            return;
        }
        if (minecraft.getDebugOverlay().showDebugScreen() && !CONFIG.showBoardOnF3Screen()) {
            return;
        }
        if (minecraft.screen instanceof BoardScreen) {
            return;
        }
        PositionAndScale pos = BingoClient.getBoardPosition();
        BingoClient.renderBingo(graphics, minecraft.screen instanceof ChatScreen, pos);
        if (CONFIG.isShowScoreCounter() && clientGame.renderMode() == BingoGameMode.RenderMode.ALL_TEAMS) {
            int scoreY;
            class TeamValue {
                final BingoBoard.Teams team;
                int score;

                TeamValue(BingoBoard.Teams team) {
                    this.team = team;
                }
            }
            TeamValue[] teams = new TeamValue[clientGame.teams().length];
            for (int i = 0; i < teams.length; ++i) {
                teams[i] = new TeamValue(BingoBoard.Teams.fromOne(i));
            }
            int totalScore = 0;
            for (BingoBoard.Teams state : clientGame.states()) {
                if (!state.any()) continue;
                ++totalScore;
                ++teams[state.getFirstIndex()].score;
            }
            Arrays.sort(teams, Comparator.comparing(v -> -v.score));
            Font font = minecraft.font;
            int scoreX = (int)(pos.x() * pos.scale() + (float)BingoClient.getBoardWidth() * pos.scale() / 2.0f);
            if (BingoClient.CONFIG.getBoardCorner().isOnBottom) {
                float f = (pos.y() - 3.0f) * pos.scale();
                Objects.requireNonNull(font);
                scoreY = (int)(f - 9.0f);
            } else {
                scoreY = (int)(pos.y() * pos.scale() + (float)(BingoClient.getBoardHeight() + 3) * pos.scale());
            }
            int shift = BingoClient.CONFIG.getBoardCorner().isOnBottom ? -12 : 12;
            for (TeamValue teamValue : teams) {
                if (teamValue.score == 0) break;
                PlayerTeam team = clientGame.teams()[teamValue.team.getFirstIndex()];
                MutableComponent leftText = BingoClient.getDisplayName(team).copy();
                MutableComponent rightText = Component.literal((String)(" - " + teamValue.score));
                if (team.getColor() != ChatFormatting.RESET) {
                    leftText.withStyle(team.getColor());
                    rightText.withStyle(team.getColor());
                }
                graphics.drawString(font, (Component)leftText, scoreX - font.width((FormattedText)leftText), scoreY, -1);
                graphics.drawString(font, (Component)rightText, scoreX, scoreY, -1);
                scoreY += shift;
            }
            MutableComponent leftText = Component.translatable((String)"bingo.unclaimed");
            MutableComponent rightText = Component.literal((String)(" - " + (clientGame.states().length - totalScore)));
            graphics.drawString(font, (Component)leftText, scoreX - font.width((FormattedText)leftText), scoreY, -1);
            graphics.drawString(font, (Component)rightText, scoreX, scoreY, -1);
        }
    }

    public static int getBoardWidth() {
        return 14 + 18 * clientGame.shape().getVisualSize(clientGame.size()).x();
    }

    public static int getBoardHeight() {
        return 24 + 18 * clientGame.shape().getVisualSize(clientGame.size()).y();
    }

    public static void renderBingo(GuiGraphics graphics, boolean mouseHover, PositionAndScale pos) {
        if (clientGame == null) {
            Bingo.LOGGER.warn("BingoClient.renderBingo() called when Bingo.clientGame == null!");
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        graphics.pose().pushMatrix();
        graphics.pose().scale(pos.scale(), pos.scale());
        graphics.pose().translate((float)((int)pos.x()), (float)((int)pos.y()));
        BingoMousePos mousePos = mouseHover ? BingoMousePos.getPos(minecraft, clientGame.shape(), clientGame.size(), pos) : null;
        Vec2i visualSize = clientGame.shape().getVisualSize(clientGame.size());
        int goalCount = clientGame.shape().getGoalCount(clientGame.size());
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BOARD_TEXTURE, 0, 0, 7 + 18 * visualSize.x() + 7, 17 + 18 * visualSize.y() + 7);
        for (int goalIndex = 0; goalIndex < goalCount; ++goalIndex) {
            Vec2i slotPos = clientGame.shape().getCoords(clientGame.size(), goalIndex);
            int slotX = slotPos.x() * 18 + 7;
            int slotY = slotPos.y() * 18 + 17;
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BOARD_CELL_TEXTURE, slotX, slotY, 18, 18);
        }
        BingoClient.renderBoardTitle(graphics, minecraft.font);
        if (BingoMousePos.hasSlotPos(mousePos)) {
            graphics.pose().pushMatrix();
            Vec2i slotPos = mousePos.getSlotPos(clientGame);
            int slotX = slotPos.x() * 18 + 8;
            int slotY = slotPos.y() * 18 + 18;
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_SPRITE, slotX - 4, slotY - 4, 24, 24);
            graphics.pose().popMatrix();
        }
        boolean spectator = minecraft.player != null && minecraft.player.isSpectator();
        for (int goalIndex = 0; goalIndex < goalCount; ++goalIndex) {
            Integer manualHighlight;
            Vec2i slotPos = clientGame.shape().getCoords(clientGame.size(), goalIndex);
            ActiveGoal goal = clientGame.goals()[goalIndex];
            BingoBoard.Teams state = clientGame.states()[goalIndex];
            boolean isGoalCompleted = state.and(clientTeam);
            int slotX = slotPos.x() * 18 + 8;
            int slotY = slotPos.y() * 18 + 18;
            Integer color = switch (clientGame.renderMode()) {
                default -> throw new MatchException(null, null);
                case BingoGameMode.RenderMode.FANCY -> {
                    if (isGoalCompleted) {
                        yield 0x55FF55;
                    }
                    yield goal.specialType().incompleteColor;
                }
                case BingoGameMode.RenderMode.ALL_TEAMS -> {
                    if (!state.any()) {
                        yield null;
                    }
                    BingoBoard.Teams team = isGoalCompleted ? clientTeam : state;
                    Integer maybeColor = clientGame.teams()[team.getFirstIndex()].getColor().getColor();
                    yield maybeColor != null ? maybeColor : 0x55FF55;
                }
            };
            if (color != null) {
                graphics.fill(slotX, slotY, slotX + 16, slotY + 16, 0xA0000000 | color);
            }
            if ((manualHighlight = clientGame.manualHighlights()[goalIndex]) != null) {
                int highlightColor = ARGB.color((int)255, (int)CONFIG.getManualHighlightColor(manualHighlight));
                graphics.hLine(slotX, slotX + 15, slotY, highlightColor);
                graphics.hLine(slotX, slotX + 15, slotY + 15, highlightColor);
                graphics.vLine(slotX, slotY, slotY + 15, highlightColor);
                graphics.vLine(slotX + 15, slotY, slotY + 15, highlightColor);
            }
            GoalIcon icon = goal.icon();
            IconRenderer<GoalIcon> renderer = IconRenderers.getRenderer(icon);
            renderer.render(icon, graphics, slotX, slotY);
            renderer.renderDecorations(icon, minecraft.font, graphics, slotX, slotY);
            GoalProgress progress = clientGame.progress()[goalIndex];
            if (progress == null || isGoalCompleted || progress.progress() <= 0 || spectator) continue;
            int pWidth = Math.round((float)progress.progress() * 13.0f / (float)progress.maxProgress());
            int pColor = Mth.hsvToRgb((float)((float)progress.progress() / (float)progress.maxProgress() / 3.0f), (float)1.0f, (float)1.0f);
            int pX = slotX + 2;
            int pY = slotY + 13;
            graphics.fill(pX, pY, pX + 13, pY + 2, -16777216);
            graphics.fill(pX, pY, pX + pWidth, pY + 1, pColor | 0xFF000000);
        }
        if (BingoMousePos.hasSlotPos(mousePos)) {
            Vec2i slotPos = mousePos.getSlotPos(clientGame);
            int slotX = slotPos.x() * 18 + 8;
            int slotY = slotPos.y() * 18 + 18;
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_FRONT_SPRITE, slotX - 4, slotY - 4, 24, 24);
        }
        if (!clientGame.nerfedTeams().and(clientTeam)) {
            for (int goalIndex = 0; goalIndex < goalCount; ++goalIndex) {
                if (!clientGame.shape().isNerfCell(clientGame.size(), goalIndex)) continue;
                Vec2i slotPos = clientGame.shape().getCoords(clientGame.size(), goalIndex);
                int slotX = slotPos.x() * 18 + 8;
                int slotY = slotPos.y() * 18 + 18;
                graphics.fill(slotX, slotY, slotX + 16, slotY + 16, Integer.MIN_VALUE);
            }
        }
        graphics.pose().popMatrix();
        if (BingoMousePos.hasSlotPos(mousePos)) {
            ActiveGoal goal = clientGame.goals()[mousePos.goalIndex()];
            GoalProgress progress = clientGame.progress()[mousePos.goalIndex()];
            TooltipBuilder tooltip = new TooltipBuilder();
            tooltip.add(goal.name());
            if (progress != null && (progress.maxProgress() > 1 || minecraft.options.advancedItemTooltips)) {
                tooltip.add((Component)Component.translatable((String)"bingo.progress", (Object[])new Object[]{progress.progress(), progress.maxProgress()}));
            }
            if (minecraft.options.advancedItemTooltips) {
                tooltip.add((Component)Component.literal((String)goal.id().toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
            goal.tooltip().ifPresent(component -> {
                int width = Math.max(300, minecraft.font.width((FormattedText)goal.name()));
                tooltip.add(FormattedCharSequence.EMPTY);
                minecraft.font.split((FormattedText)component, width).forEach(tooltip::add);
            });
            goal.tooltipIcon().map(IconTooltip::new).ifPresent(tooltip::add);
            tooltip.draw(minecraft.font, graphics, (int)mousePos.mouseX(), (int)mousePos.mouseY());
        }
    }

    private static void renderBoardTitle(GuiGraphics graphics, Font font) {
        int maxWidth = BingoClient.getBoardWidth() - 16;
        FormattedCharSequence title = font.width((FormattedText)BOARD_TITLE) > maxWidth ? BingoClient.getVisualOrderWithEllipses(BOARD_TITLE_SHORT, font, maxWidth) : BOARD_TITLE.getVisualOrderText();
        graphics.drawString(font, title, 8, 6, -12566464, false);
    }

    public static FormattedCharSequence getVisualOrderWithEllipses(Component text, Font font, int maxWidth) {
        int textWidth = font.width((FormattedText)text);
        if (textWidth <= maxWidth) {
            return text.getVisualOrderText();
        }
        FormattedText shortText = font.substrByWidth((FormattedText)text, maxWidth - font.width((FormattedText)CommonComponents.ELLIPSIS));
        FormattedText combinedText = FormattedText.composite((FormattedText[])new FormattedText[]{shortText, CommonComponents.ELLIPSIS});
        return Language.getInstance().getVisualOrder(combinedText);
    }

    public static boolean detectClick(int button, PositionAndScale boardPos) {
        return BingoClient.detectClickOrPress(InputConstants.Type.MOUSE.getOrCreate(button), boardPos);
    }

    public static boolean detectPress(KeyEvent event, PositionAndScale boardPos) {
        return BingoClient.detectClickOrPress(InputConstants.getKey((KeyEvent)event), boardPos);
    }

    public static boolean detectClickOrPress(InputConstants.Key key, PositionAndScale boardPos) {
        if (clientGame == null) {
            return false;
        }
        BingoMousePos mousePos = BingoMousePos.getPos(Minecraft.getInstance(), clientGame.shape(), clientGame.size(), boardPos);
        if (!mousePos.hasSlotPos()) {
            return false;
        }
        if (key.equals((Object)BingoClient.manualHighlightKeyMapping.key)) {
            Integer nextHighlight;
            Integer manualHighlight;
            Integer n = manualHighlight = clientGame.manualHighlights()[mousePos.goalIndex()];
            int n2 = 0;
            BingoClient.clientGame.manualHighlights()[mousePos.goalIndex()] = nextHighlight = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{2}, (Object)n, n2)) {
                case -1 -> 0;
                case 0 -> null;
                default -> manualHighlight + 1;
            });
            new ManualHighlightPayload(mousePos.goalIndex(), nextHighlight == null ? 0 : nextHighlight + 1, clientGame.manualHighlightModCount().getValue()).sendToServer();
            clientGame.manualHighlightModCount().increment();
            AbstractButton.playButtonClickSound((SoundManager)Minecraft.getInstance().getSoundManager());
        }
        ActiveGoal goal = clientGame.goals()[mousePos.goalIndex()];
        RecipeViewerPlugin plugin = BingoClient.getRecipeViewerPlugin();
        if (plugin.isViewRecipe(key)) {
            plugin.showRecipe(IconRenderers.getRenderer(goal.icon()).getIconItem(goal.icon()));
            return true;
        }
        if (plugin.isViewUsages(key)) {
            plugin.showUsages(IconRenderers.getRenderer(goal.icon()).getIconItem(goal.icon()));
            return true;
        }
        return false;
    }

    public static Component getDisplayName(PlayerTeam team) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection != null) {
            Iterator players = team.getPlayers().stream().map(arg_0 -> ((ClientPacketListener)connection).getPlayerInfo(arg_0)).filter(Objects::nonNull).iterator();
            if (players.hasNext()) {
                PlayerInfo playerInfo = (PlayerInfo)players.next();
                if (!players.hasNext()) {
                    Player player;
                    ClientLevel level = Minecraft.getInstance().level;
                    if (level != null && (player = level.getPlayerByUUID(playerInfo.getProfile().id())) != null) {
                        return player.getName();
                    }
                    return Component.literal((String)playerInfo.getProfile().name());
                }
            }
        }
        return team.getDisplayName();
    }

    static {
        clientTeam = BingoBoard.Teams.NONE;
        receivedClientTeam = BingoBoard.Teams.NONE;
        CONFIG = new BingoClientConfig(BingoPlatform.platform.getConfigDir().resolve("bingo-client.toml"));
    }
}

