/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client;

import io.github.gaming32.bingo.client.BingoClient;
import io.github.gaming32.bingo.client.PositionAndScale;
import io.github.gaming32.bingo.game.BingoBoard;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.world.scores.PlayerTeam;

public class BoardScreen
extends Screen {
    private Button leftButton;
    private Button rightButton;

    public BoardScreen() {
        super(BingoClient.BOARD_TITLE);
    }

    protected void init() {
        int n = this.height / 2 + BingoClient.getBoardHeight() / 2;
        Objects.requireNonNull(this.font);
        int buttonY = n + 9 + 6;
        this.leftButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), b -> this.switchTeam(-1)).width(20).pos(this.width / 2 - 20 - 4, buttonY).build());
        this.rightButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), b -> this.switchTeam(1)).width(20).pos(this.width / 2 + 4, buttonY).build());
        this.updateButtonVisibility();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (BingoClient.clientGame == null) {
            return;
        }
        PositionAndScale pos = this.getPosition();
        BingoClient.renderBingo(graphics, true, pos);
        assert (this.minecraft != null);
        if (this.minecraft.player != null && this.minecraft.player.isSpectator()) {
            PlayerTeam team = BingoClient.clientGame.teams()[BingoClient.clientTeam.getFirstIndex()];
            Integer color = team.getColor().getColor();
            graphics.drawCenteredString(this.font, BingoClient.getDisplayName(team), this.width / 2, (int)pos.y() + BingoClient.getBoardHeight() + 3, color != null ? ARGB.color((int)255, (int)color) : -1);
        }
    }

    public boolean keyPressed(KeyEvent event) {
        assert (this.minecraft != null);
        if (BingoClient.clientGame != null && BingoClient.detectPress(event, this.getPosition())) {
            return true;
        }
        if (this.leftButton.visible && this.minecraft.options.keyLeft.matches(event)) {
            this.switchTeam(-1);
        } else if (this.rightButton.visible && this.minecraft.options.keyRight.matches(event)) {
            this.switchTeam(-1);
        }
        return super.keyPressed(event);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (BingoClient.clientGame != null && BingoClient.detectClick(event.button(), this.getPosition())) {
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public void tick() {
        if (this.minecraft == null) {
            return;
        }
        if (BingoClient.clientGame == null) {
            this.minecraft.setScreen(null);
        } else {
            this.updateButtonVisibility();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public PositionAndScale getPosition() {
        return new PositionAndScale((float)this.width / 2.0f - (float)BingoClient.getBoardWidth() / 2.0f, (float)this.height / 2.0f - (float)BingoClient.getBoardHeight() / 2.0f, 1.0f);
    }

    private void updateButtonVisibility() {
        boolean isSpectator;
        assert (this.minecraft != null);
        this.leftButton.visible = isSpectator = this.minecraft.player != null && this.minecraft.player.isSpectator();
        this.rightButton.visible = isSpectator;
    }

    private void switchTeam(int dir) {
        int currentIndex = BingoClient.clientTeam.getFirstIndex();
        int newIndex = Math.floorMod(currentIndex + dir, BingoClient.clientGame.teams().length);
        BingoClient.clientTeam = BingoBoard.Teams.fromOne(newIndex);
    }
}

