/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client;

import io.github.gaming32.bingo.client.BingoClient;
import io.github.gaming32.bingo.client.ClientGame;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.util.ResourceLocations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.spectator.SpectatorMenu;
import net.minecraft.client.gui.spectator.SpectatorMenuCategory;
import net.minecraft.client.gui.spectator.SpectatorMenuItem;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.PlayerTeam;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamSelectionSpectatorCategory
implements SpectatorMenuCategory,
SpectatorMenuItem {
    private static final ResourceLocation CATEGORY_SPRITE = ResourceLocations.bingo("spectator/team_selection");
    private static final Component CATEGORY_NAME = Component.translatable((String)"bingo.spectator.team_selection");
    private static final Component CATEGORY_PROMPT = Component.translatable((String)"bingo.spectator.team_selection.prompt");
    private final List<SpectatorMenuItem> items = TeamSelectionSpectatorCategory.createTeamEntries(BingoClient.clientGame);

    private static List<SpectatorMenuItem> createTeamEntries(@Nullable ClientGame game) {
        if (game == null) {
            return List.of();
        }
        MutableInt teamId = new MutableInt();
        return Arrays.stream(game.teams()).map(team -> TeamSelectionItem.create(game, team, BingoBoard.Teams.fromOne(teamId.getAndIncrement()))).filter(Objects::nonNull).toList();
    }

    @NotNull
    public List<SpectatorMenuItem> getItems() {
        return this.items;
    }

    @NotNull
    public Component getPrompt() {
        return CATEGORY_PROMPT;
    }

    public void selectItem(SpectatorMenu menu) {
        menu.selectCategory((SpectatorMenuCategory)this);
    }

    @NotNull
    public Component getName() {
        return CATEGORY_NAME;
    }

    public void renderIcon(GuiGraphics graphics, float brightness, float alpha) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, CATEGORY_SPRITE, 0, 0, 16, 16, ARGB.colorFromFloat((float)alpha, (float)brightness, (float)brightness, (float)brightness));
    }

    public boolean isEnabled() {
        return !this.items.isEmpty();
    }

    private record TeamSelectionItem(PlayerTeam playerTeam, BingoBoard.Teams teamState, @Nullable PlayerSkin iconSkin, Component displayName) implements SpectatorMenuItem
    {
        @Nullable
        public static SpectatorMenuItem create(ClientGame game, PlayerTeam team, BingoBoard.Teams teamId) {
            PlayerSkin iconSkin;
            Minecraft minecraft = Minecraft.getInstance();
            ArrayList<PlayerInfo> onlinePlayers = new ArrayList<PlayerInfo>();
            for (String playerName : team.getPlayers()) {
                PlayerInfo playerInfo = minecraft.getConnection().getPlayerInfo(playerName);
                if (playerInfo == null || playerInfo.getGameMode() == GameType.SPECTATOR) continue;
                onlinePlayers.add(playerInfo);
            }
            if (onlinePlayers.isEmpty()) {
                boolean hasAnyGoals = false;
                for (int i = 0; i < game.states().length; ++i) {
                    boolean hasGoal = game.states()[i].and(teamId);
                    if (game.goals()[i].specialType() == BingoTag.SpecialType.NEVER) {
                        boolean bl = hasGoal = !hasGoal;
                    }
                    if (!hasGoal) continue;
                    hasAnyGoals = true;
                    break;
                }
                if (!hasAnyGoals) {
                    return null;
                }
            }
            if (onlinePlayers.isEmpty()) {
                iconSkin = null;
            } else {
                PlayerInfo teamFace = (PlayerInfo)onlinePlayers.get(RandomSource.create().nextInt(onlinePlayers.size()));
                iconSkin = teamFace.getSkin();
            }
            return new TeamSelectionItem(team, teamId, iconSkin, BingoClient.getDisplayName(team));
        }

        public void selectItem(SpectatorMenu menu) {
            BingoClient.clientTeam = this.teamState;
        }

        @NotNull
        public Component getName() {
            return this.displayName;
        }

        public void renderIcon(GuiGraphics graphics, float brightness, float alpha) {
            Integer color = this.playerTeam.getColor().getColor();
            if (color != null) {
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                graphics.fill(1, 1, 15, 15, ARGB.colorFromFloat((float)alpha, (float)(red * brightness), (float)(green * brightness), (float)(blue * brightness)));
            }
            if (this.iconSkin != null) {
                PlayerFaceRenderer.draw((GuiGraphics)graphics, (PlayerSkin)this.iconSkin, (int)2, (int)2, (int)12, (int)ARGB.white((float)alpha));
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

