/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class TooltipBuilder {
    private final List<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
    private ResourceLocation background = null;

    public TooltipBuilder add(ClientTooltipComponent component) {
        this.lines.add(component);
        return this;
    }

    public TooltipBuilder add(TooltipComponent component) {
        return this.add(ClientTooltipComponent.create((TooltipComponent)component));
    }

    public TooltipBuilder add(FormattedCharSequence text) {
        return this.add(ClientTooltipComponent.create((FormattedCharSequence)text));
    }

    public TooltipBuilder add(Component component) {
        return this.add(component.getVisualOrderText());
    }

    public TooltipBuilder background(ResourceLocation background) {
        this.background = background;
        return this;
    }

    public void draw(Font font, GuiGraphics graphics, int mouseX, int mouseY) {
        this.draw(font, graphics, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE);
    }

    public void draw(Font font, GuiGraphics graphics, int mouseX, int mouseY, ClientTooltipPositioner positioner) {
        graphics.setTooltipForNextFrameInternal(font, this.lines, mouseX, mouseY, positioner, this.background, false);
    }
}

