/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.config;

import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.client.BingoClient;
import io.github.gaming32.bingo.client.config.BoardCorner;
import io.github.gaming32.bingo.ext.RowHelperExt;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;

public class BingoConfigScreen
extends Screen {
    private final Screen parent;

    public BingoConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"bingo.client_config.title"));
        this.parent = parent;
    }

    protected void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.defaultCellSetting().paddingHorizontal(5).paddingBottom(4).alignHorizontallyCenter();
        GridLayout.RowHelper rowHelper = gridLayout.createRowHelper(2);
        rowHelper.addChild(this.createCornerButton());
        rowHelper.addChild(this.createShowBoardOnF3ScreenButton());
        rowHelper.addChild((LayoutElement)this.createSizeSlider());
        rowHelper.addChild(this.createShowScoreCounterButton());
        ((RowHelperExt)rowHelper).bingo$ensureNewLine();
        for (int slot = 0; slot < 3; ++slot) {
            this.addManualHighlightColorTextField(rowHelper, slot);
        }
        rowHelper.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.parent)).width(200).build(), 2, rowHelper.newCellSettings().paddingTop(2));
        rowHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"controls.reset"), button -> {
            BingoClient.CONFIG.reset();
            this.init();
            BingoClient.CONFIG.save();
        }).width(200).build(), 2, rowHelper.newCellSettings().paddingTop(2));
        gridLayout.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)gridLayout, (int)0, (int)(this.height / 6 - 12), (int)this.width, (int)this.height, (float)0.5f, (float)0.0f);
        gridLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 15, -1);
    }

    private CycleButton<BoardCorner> createCornerButton() {
        return CycleButton.builder(BoardCorner::getDescription).withValues((Object[])BoardCorner.values()).withInitialValue((Object)BingoClient.CONFIG.getBoardCorner()).create(0, 0, 150, 20, (Component)Component.translatable((String)"bingo.client_config.board_corner"), (button, corner) -> {
            BingoClient.CONFIG.setBoardCorner((BoardCorner)((Object)corner));
            BingoClient.CONFIG.save();
        });
    }

    private CycleButton<Boolean> createShowBoardOnF3ScreenButton() {
        return CycleButton.onOffBuilder().withInitialValue((Object)BingoClient.CONFIG.showBoardOnF3Screen()).withTooltip(v -> Tooltip.create((Component)Component.translatable((String)"bingo.client_config.show_board_on_f3_screen.tooltip"))).create(0, 0, 150, 20, (Component)Component.translatable((String)"bingo.client_config.show_board_on_f3_screen"), (button, show) -> {
            BingoClient.CONFIG.setShowBoardOnF3Screen((boolean)show);
            BingoClient.CONFIG.save();
        });
    }

    private AbstractSliderButton createSizeSlider() {
        return new AbstractSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, (Math.log10(BingoClient.CONFIG.getBoardScale()) + 1.0) / 2.0){
            private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("0.##");
            {
                this.updateMessage();
            }

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)"bingo.client_config.board_scale", (Object[])new Object[]{NUMBER_FORMAT.format(this.getRealValue())}));
            }

            protected void applyValue() {
                BingoClient.CONFIG.setBoardScale((float)this.getRealValue());
                BingoClient.CONFIG.save();
            }

            private double getRealValue() {
                return Math.pow(10.0, this.value * 2.0 - 1.0);
            }
        };
    }

    private CycleButton<Boolean> createShowScoreCounterButton() {
        return CycleButton.onOffBuilder().withInitialValue((Object)BingoClient.CONFIG.isShowScoreCounter()).withTooltip(v -> Tooltip.create((Component)Component.translatable((String)"bingo.client_config.show_score_counter.tooltip"))).create(0, 0, 150, 20, (Component)Component.translatable((String)"bingo.client_config.show_score_counter"), (button, show) -> {
            BingoClient.CONFIG.setShowScoreCounter((boolean)show);
            BingoClient.CONFIG.save();
        });
    }

    private void addManualHighlightColorTextField(GridLayout.RowHelper rowHelper, int highlightValue) {
        MutableComponent label = Bingo.translatable("bingo.client_config.manual_highlight_color", highlightValue + 1);
        int color = BingoClient.CONFIG.getManualHighlightColor(highlightValue) & 0xFFFFFF;
        EditBox editBox = new EditBox(this.font, 150, 20, (Component)label);
        editBox.setValue("%06X".formatted(color));
        ColorBox colorBox = new ColorBox(this.font, 20, 20, (Component)label, color);
        editBox.setResponder(value -> {
            int newColor;
            try {
                newColor = Integer.parseInt(value, 16) & 0xFFFFFF;
            }
            catch (NumberFormatException e) {
                editBox.setTextColor(-65536);
                return;
            }
            editBox.setTextColor(-2039584);
            colorBox.color = newColor;
            BingoClient.CONFIG.setManualHighlightColor(highlightValue, newColor);
            BingoClient.CONFIG.save();
        });
        rowHelper.addChild((LayoutElement)colorBox);
        rowHelper.addChild((LayoutElement)editBox);
    }

    private static class ColorBox
    extends AbstractWidget {
        private final Font font;
        private final Component label;
        private int color;

        public ColorBox(Font font, int width, int height, Component label, int color) {
            super(0, 0, font.width((FormattedText)label) + 5 + width, height, (Component)Component.empty());
            this.font = font;
            this.label = label;
            this.color = color;
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int labelWidth = this.font.width((FormattedText)this.label);
            int n = this.getX();
            int n2 = this.getY();
            int n3 = this.getHeight();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, this.label, n, n2 + (n3 - 9) / 2, -1);
            int boxLeft = this.getX() + labelWidth + 5;
            graphics.fill(boxLeft, this.getY(), this.getRight() - 1, this.getBottom(), ARGB.color((int)255, (int)this.color));
            graphics.hLine(boxLeft, this.getRight() - 1, this.getY(), -16777216);
            graphics.hLine(boxLeft, this.getRight() - 1, this.getBottom() - 1, -16777216);
            graphics.vLine(boxLeft, this.getY(), this.getBottom() - 1, -16777216);
            graphics.vLine(this.getRight() - 1, this.getY(), this.getBottom() - 1, -16777216);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

