/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.config;

import io.github.gaming32.bingo.client.BingoClient;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum BoardCorner {
    UPPER_LEFT(false, false){

        @Override
        public float getX(float guiWidth, float scale) {
            return 3.0f;
        }

        @Override
        public float getY(float guiHeight, float scale) {
            return 3.0f;
        }
    }
    ,
    UPPER_RIGHT(false, true){

        @Override
        public float getX(float guiWidth, float scale) {
            return guiWidth / scale - 3.0f - (float)BingoClient.getBoardWidth();
        }

        @Override
        public float getY(float guiHeight, float scale) {
            Minecraft minecraft = Minecraft.getInstance();
            float result = 3.0f;
            if (minecraft.isDemo()) {
                result += 15.0f;
            }
            return result;
        }
    }
    ,
    LOWER_LEFT(true, false){

        @Override
        public float getX(float guiWidth, float scale) {
            return 3.0f;
        }

        @Override
        public float getY(float guiHeight, float scale) {
            return guiHeight / scale - 3.0f - (float)BingoClient.getBoardHeight();
        }
    }
    ,
    LOWER_RIGHT(true, true){

        @Override
        public float getX(float guiWidth, float scale) {
            return guiWidth / scale - 3.0f - (float)BingoClient.getBoardWidth();
        }

        @Override
        public float getY(float guiHeight, float scale) {
            return guiHeight / scale - 3.0f - (float)BingoClient.getBoardHeight();
        }
    };

    public final boolean isOnBottom;
    public final boolean isOnRight;

    private BoardCorner(boolean isOnBottom, boolean isOnRight) {
        this.isOnBottom = isOnBottom;
        this.isOnRight = isOnRight;
    }

    public abstract float getX(float var1, float var2);

    public abstract float getY(float var1, float var2);

    @NotNull
    public Component getDescription() {
        return Component.translatable((String)("bingo.board_corner." + this.name().toLowerCase(Locale.ROOT)));
    }
}

