/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.icons;

import io.github.gaming32.bingo.client.icons.IconRenderer;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;

public interface AbstractCycleIconRenderer<I extends GoalIcon>
extends IconRenderer<I> {
    public static final long TIME_PER_ICON = 2000L;

    public void renderWithParentPeriod(int var1, I var2, GuiGraphics var3, int var4, int var5);

    @Override
    default public void render(I icon, GuiGraphics graphics, int x, int y) {
        this.renderWithParentPeriod(1, icon, graphics, x, y);
    }

    public void renderDecorationsWithParentPeriod(int var1, I var2, Font var3, GuiGraphics var4, int var5, int var6);

    @Override
    default public void renderDecorations(I icon, Font font, GuiGraphics graphics, int x, int y) {
        this.renderDecorationsWithParentPeriod(1, icon, font, graphics, x, y);
    }

    @Override
    default public ItemStack getIconItem(I icon) {
        return this.getIconItemWithParentPeriod(1, icon);
    }

    public ItemStack getIconItemWithParentPeriod(int var1, I var2);

    public static <T extends FeatureElement> Optional<Holder<T>> getIconFromTag(HolderSet<T> tag, int parentPeriod) {
        if (tag.size() == 0) {
            return Optional.empty();
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return Optional.of(tag.get(AbstractCycleIconRenderer.getIconIndex(tag.size(), parentPeriod)));
        }
        FeatureFlagSet features = level.enabledFeatures();
        int size = (int)tag.stream().filter(t -> ((FeatureElement)t.value()).isEnabled(features)).count();
        int index = AbstractCycleIconRenderer.getIconIndex(size, parentPeriod);
        if (size == tag.size()) {
            return Optional.of(tag.get(index));
        }
        Stream<Holder> stream = tag.stream().filter(t -> ((FeatureElement)t.value()).isEnabled(features));
        if (index > 0) {
            stream = stream.skip(index - 1);
        }
        return stream.findFirst();
    }

    public static int getIconIndex(int size, int parentPeriod) {
        return (int)(Util.getMillis() / (2000L * (long)parentPeriod) % (long)size);
    }
}

