/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.icons;

import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import io.github.gaming32.bingo.client.icons.IconRenderer;
import io.github.gaming32.bingo.data.icons.EntityIcon;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.CacheSlot;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class EntityIconRenderer
implements IconRenderer<EntityIcon> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CacheSlot<ClientLevel, Map<EntityIcon, Entity>> ENTITIES = new CacheSlot(l -> new WeakHashMap());

    @Override
    public void render(EntityIcon icon, GuiGraphics graphics, int x, int y) {
        Entity entity = EntityIconRenderer.getEntity(icon);
        if (entity == null) {
            return;
        }
        EntityIconRenderer.renderEntity(entity, graphics, x, y);
    }

    public static void renderEntity(Entity entity, GuiGraphics graphics, int x, int y) {
        LivingEntity living;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        float size = 14.0f;
        if (Math.max(entity.getBbWidth(), entity.getBbHeight()) > 1.0f) {
            size /= Math.max(entity.getBbWidth(), entity.getBbHeight());
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).isBaby()) {
            size /= 1.7f;
        }
        Vector3f translation = new Vector3f(0.0f, entity.getBbHeight() / 2.0f + 0.0625f, 0.0f);
        Quaternionf xRot = Axis.XP.rotationDegrees(-10.0f);
        Quaternionf rotation = Axis.ZP.rotationDegrees(180.0f).mul((Quaternionfc)xRot);
        xRot.conjugate();
        entity.tickCount = minecraft.player.tickCount;
        entity.setYRot(-150.0f);
        entity.setYHeadRot(-150.0f);
        entity.setYBodyRot(-150.0f);
        entity.setXRot(0.0f);
        EntityRenderDispatcher renderDispatcher = minecraft.getEntityRenderDispatcher();
        Vector2f topLeft = graphics.pose().transformPosition((float)x, (float)y, new Vector2f());
        Vector2f bottomRight = graphics.pose().transformPosition((float)(x + 16), (float)(y + 16), new Vector2f());
        EntityRenderer entityRenderer = renderDispatcher.getRenderer(entity);
        graphics.submitEntityRenderState(entityRenderer.createRenderState(entity, 1.0f), size, translation, rotation, xRot, (int)topLeft.x, (int)topLeft.y, (int)bottomRight.x, (int)bottomRight.y);
    }

    @Nullable
    private static Entity getEntity(EntityIcon icon) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        return ((Map)ENTITIES.compute((CacheSlot.Cleaner)level)).computeIfAbsent(icon, EntityIconRenderer::createEntity);
    }

    @Nullable
    private static Entity createEntity(EntityIcon icon) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        Entity entity = icon.entity().create((Level)level, EntitySpawnReason.LOAD);
        if (entity != null) {
            try (ProblemReporter.ScopedCollector collector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new ProblemReporter.FieldPathElement("data"), LOGGER);){
                ValueInput input = TagValueInput.create((ProblemReporter)collector, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)icon.data());
                entity.load(input);
            }
        }
        return entity;
    }
}

