/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.icons;

import io.github.gaming32.bingo.client.icons.AbstractCycleIconRenderer;
import io.github.gaming32.bingo.client.icons.EntityIconRenderer;
import io.github.gaming32.bingo.client.icons.IconRenderer;
import io.github.gaming32.bingo.data.icons.EntityTypeTagCycleIcon;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityTypeTagCycleIconRenderer
implements AbstractCycleIconRenderer<EntityTypeTagCycleIcon> {
    private static final Map<ClientLevel, Map<EntityType<?>, Entity>> ENTITIES = new WeakHashMap();

    @Override
    public void renderWithParentPeriod(int parentPeriod, EntityTypeTagCycleIcon icon, GuiGraphics graphics, int x, int y) {
        Optional entityTypes = BuiltInRegistries.ENTITY_TYPE.get(icon.tag());
        if (entityTypes.isEmpty()) {
            return;
        }
        Optional entityType = AbstractCycleIconRenderer.getIconFromTag((HolderSet)entityTypes.get(), parentPeriod);
        if (entityType.isEmpty()) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = ENTITIES.computeIfAbsent(level, k -> new HashMap()).computeIfAbsent((EntityType)entityType.get().value(), k -> k.create((Level)level, EntitySpawnReason.LOAD));
        if (entity == null) {
            return;
        }
        EntityIconRenderer.renderEntity(entity, graphics, x, y);
    }

    @Override
    public void renderDecorationsWithParentPeriod(int parentPeriod, EntityTypeTagCycleIcon icon, Font font, GuiGraphics graphics, int x, int y) {
        IconRenderer.renderCount(icon.count(), font, graphics, x, y);
    }

    @Override
    public ItemStack getIconItemWithParentPeriod(int parentPeriod, EntityTypeTagCycleIcon icon) {
        Optional entityTypes = BuiltInRegistries.ENTITY_TYPE.get(icon.tag());
        if (entityTypes.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Optional entityType = AbstractCycleIconRenderer.getIconFromTag((HolderSet)entityTypes.get(), parentPeriod);
        if (entityType.isEmpty()) {
            return ItemStack.EMPTY;
        }
        SpawnEggItem spawnEggItem = SpawnEggItem.byId((EntityType)((EntityType)entityType.get().value()));
        return spawnEggItem != null ? new ItemStack((ItemLike)spawnEggItem, icon.count()) : ItemStack.EMPTY;
    }
}

