/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.icons;

import io.github.gaming32.bingo.data.icons.GoalIcon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;

public interface IconRenderer<I extends GoalIcon> {
    public void render(I var1, GuiGraphics var2, int var3, int var4);

    default public void renderDecorations(I icon, Font font, GuiGraphics graphics, int x, int y) {
        graphics.renderItemDecorations(font, this.getIconItem(icon), x, y);
    }

    default public ItemStack getIconItem(I icon) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        return connection != null ? icon.getFallback((RegistryAccess)connection.registryAccess()) : icon.getFallbackWithStaticContext();
    }

    public static void renderCount(int count, Font font, GuiGraphics graphics, int x, int y) {
        if (count == 1) {
            return;
        }
        String text = Integer.toString(count);
        graphics.drawString(font, text, x + 19 - 2 - font.width(text), y + 6 + 3, -1, true);
    }
}

