/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.icons;

import io.github.gaming32.bingo.client.icons.IconRenderer;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.icons.GoalIconType;
import io.github.gaming32.bingo.platform.registry.RegistryValue;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.resources.ResourceLocation;

public final class IconRenderers {
    private static final Map<ResourceLocation, IconRenderer<?>> RENDERERS = new HashMap();

    private IconRenderers() {
    }

    public static <I extends GoalIcon> void register(GoalIconType<I> iconType, IconRenderer<I> renderer) {
        ResourceLocation id = GoalIconType.REGISTER.registry().getKey(iconType);
        if (id == null) {
            throw new IllegalArgumentException("Tried to register renderer for unregistered icon type " + String.valueOf(iconType));
        }
        RENDERERS.put(id, renderer);
    }

    public static <I extends GoalIcon> void register(RegistryValue<GoalIconType<I>> iconType, IconRenderer<I> renderer) {
        RENDERERS.put(iconType.id(), renderer);
    }

    public static <I extends GoalIcon> IconRenderer<I> getRenderer(GoalIconType<I> iconType) {
        ResourceLocation id = GoalIconType.REGISTER.registry().getKey(iconType);
        if (id == null) {
            throw new NoSuchElementException("Unknown id for icon type " + String.valueOf(iconType));
        }
        return IconRenderers.getRenderer(id);
    }

    public static <I extends GoalIcon> IconRenderer<I> getRenderer(RegistryValue<GoalIconType<I>> iconType) {
        return IconRenderers.getRenderer(iconType.id());
    }

    public static <I extends GoalIcon> IconRenderer<I> getRenderer(I icon) {
        return IconRenderers.getRenderer(icon.type());
    }

    private static <I extends GoalIcon> IconRenderer<I> getRenderer(ResourceLocation location) {
        IconRenderer<?> renderer = RENDERERS.get(location);
        if (renderer == null) {
            throw new NoSuchElementException("Unknown renderer for icon type " + String.valueOf(location));
        }
        return renderer;
    }
}

