/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.icons;

import io.github.gaming32.bingo.client.icons.AbstractCycleIconRenderer;
import io.github.gaming32.bingo.client.icons.IconRenderer;
import io.github.gaming32.bingo.data.icons.InstrumentCycleIcon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InstrumentCycleIconRenderer
implements AbstractCycleIconRenderer<InstrumentCycleIcon> {
    @Override
    public void renderWithParentPeriod(int parentPeriod, InstrumentCycleIcon icon, GuiGraphics graphics, int x, int y) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return;
        }
        Registry instruments = connection.registryAccess().lookupOrThrow(Registries.INSTRUMENT);
        if (instruments.size() == 0) {
            return;
        }
        graphics.renderFakeItem(InstrumentItem.create((Item)((Item)icon.instrumentItem().value()), InstrumentCycleIconRenderer.getIcon((Registry<Instrument>)instruments, parentPeriod)), x, y);
    }

    @Override
    public void renderDecorationsWithParentPeriod(int parentPeriod, InstrumentCycleIcon icon, Font font, GuiGraphics graphics, int x, int y) {
        int count = 1;
        if (icon.overrideCount().isPresent()) {
            count = icon.overrideCount().getAsInt();
        } else {
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection != null) {
                count = connection.registryAccess().lookupOrThrow(Registries.INSTRUMENT).size();
            }
        }
        IconRenderer.renderCount(count, font, graphics, x, y);
    }

    @Override
    public ItemStack getIconItemWithParentPeriod(int parentPeriod, InstrumentCycleIcon icon) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return ItemStack.EMPTY;
        }
        Registry instruments = connection.registryAccess().lookupOrThrow(Registries.INSTRUMENT);
        if (instruments.size() == 0) {
            return ItemStack.EMPTY;
        }
        return InstrumentItem.create((Item)((Item)icon.instrumentItem().value()), InstrumentCycleIconRenderer.getIcon((Registry<Instrument>)instruments, parentPeriod));
    }

    private static Holder<Instrument> getIcon(Registry<Instrument> icons, int parentPeriod) {
        return icons.get(AbstractCycleIconRenderer.getIconIndex(icons.size(), parentPeriod)).or(() -> icons.getAny()).orElse(null);
    }
}

