/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.icons.pip;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.gaming32.bingo.client.icons.pip.BlockPictureInPictureRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SpecialBlockModelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockPictureInPictureRenderer
extends PictureInPictureRenderer<BlockPictureInPictureRenderState> {
    private static final float RENDER_SIZE = 16.0f;
    private static final ItemTransform DEFAULT_TRANSFORM = new ItemTransform((Vector3fc)new Vector3f(30.0f, 225.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.625f, 0.625f, 0.625f));
    private static final Quaternionfc LIGHT_FIX_ROT = Axis.YP.rotationDegrees(285.0f);

    public BlockPictureInPictureRenderer(MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
    }

    @NotNull
    public Class<BlockPictureInPictureRenderState> getRenderStateClass() {
        return BlockPictureInPictureRenderState.class;
    }

    protected void renderToTexture(BlockPictureInPictureRenderState state, PoseStack pose) {
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        float scale = state.scale();
        pose.scale(16.0f * scale, -16.0f * scale, -16.0f * scale);
        DEFAULT_TRANSFORM.apply(false, pose.last());
        pose.translate(0.5, 0.5, 0.5);
        pose.last().normal().rotate(LIGHT_FIX_ROT);
        pose.translate(-0.5, -0.5, -0.5);
        BlockPictureInPictureRenderer.renderSingleBlock(state.block(), pose, (MultiBufferSource)this.bufferSource);
    }

    @NotNull
    protected String getTextureLabel() {
        return "bingo block";
    }

    private static void renderSingleBlock(BlockState state, PoseStack poseStack, MultiBufferSource bufferSource) {
        Minecraft minecraft = Minecraft.getInstance();
        BlockRenderDispatcher dispatcher = minecraft.getBlockRenderer();
        BlockStateModel model = dispatcher.getBlockModel(state);
        int color = minecraft.getBlockColors().getColor(state, (BlockAndTintGetter)minecraft.level, BlockPos.ZERO, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)state)), (BlockStateModel)model, (float)r, (float)g, (float)b, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY);
        SubmitNodeStorage submitNodeStorage = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher().getSubmitNodeStorage();
        ((SpecialBlockModelRenderer)minecraft.getModelManager().specialBlockModelRenderer().get()).renderByBlock(state.getBlock(), ItemDisplayContext.NONE, poseStack, (SubmitNodeCollector)submitNodeStorage, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
    }

    protected float getTranslateY(int height, int guiScale) {
        return (float)height / 2.0f;
    }
}

