/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.conditions.BlockCondition;
import io.github.gaming32.bingo.conditions.BlockPatternCondition;
import io.github.gaming32.bingo.conditions.DistanceFromSpawnCondition;
import io.github.gaming32.bingo.conditions.FlammableCondition;
import io.github.gaming32.bingo.conditions.HasAnyEffectCondition;
import io.github.gaming32.bingo.conditions.HasOnlyBeenDamagedByCondition;
import io.github.gaming32.bingo.conditions.InStructureCondition;
import io.github.gaming32.bingo.conditions.OneByOneHoleCondition;
import io.github.gaming32.bingo.conditions.PassengersCondition;
import io.github.gaming32.bingo.conditions.PillarCondition;
import io.github.gaming32.bingo.conditions.StairwayToHeavenCondition;
import io.github.gaming32.bingo.conditions.ToolDamageCondition;
import io.github.gaming32.bingo.conditions.ToolIsEnchantedCondition;
import io.github.gaming32.bingo.conditions.VillagerOwnershipCondition;
import io.github.gaming32.bingo.conditions.WearingDifferentArmorCondition;
import io.github.gaming32.bingo.platform.BingoPlatform;
import io.github.gaming32.bingo.platform.registry.DeferredRegister;
import io.github.gaming32.bingo.platform.registry.RegistryValue;
import io.github.gaming32.bingo.util.ResourceLocations;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class BingoConditions {
    private static final DeferredRegister<LootItemConditionType> REGISTER = BingoPlatform.platform.createDeferredRegister(BuiltInRegistries.LOOT_CONDITION_TYPE);
    public static final RegistryValue<LootItemConditionType> BLOCK = BingoConditions.register("block", BlockCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> BLOCK_PATTERN = BingoConditions.register("block_pattern", BlockPatternCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> DISTANCE_FROM_SPAWN = BingoConditions.register("distance_from_spawn", DistanceFromSpawnCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> FLAMMABLE = BingoConditions.register("flammable", FlammableCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> HAS_ANY_EFFECT = BingoConditions.register("has_any_effect", HasAnyEffectCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> HAS_ONLY_BEEN_DAMAGED_BY = BingoConditions.register("has_only_been_damaged_by", HasOnlyBeenDamagedByCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> IN_STRUCTURE = BingoConditions.register("in_structure", InStructureCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> ONE_BY_ONE_HOLE = BingoConditions.register("one_by_one_hole", OneByOneHoleCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> PASSENGERS = BingoConditions.register("passengers", PassengersCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> PILLAR = BingoConditions.register("pillar", PillarCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> STAIRWAY_TO_HEAVEN = BingoConditions.register("stairway_to_heaven", StairwayToHeavenCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> TOOL_DAMAGE = BingoConditions.register("tool_damage", ToolDamageCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> TOOL_IS_ENCHANTED = BingoConditions.register("tool_is_enchanted", ToolIsEnchantedCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> VILLAGER_OWNERSHIP = BingoConditions.register("villager_ownership", VillagerOwnershipCondition.CODEC);
    public static final RegistryValue<LootItemConditionType> WEARING_DIFFERENT_ARMOR = BingoConditions.register("wearing_different_armor", WearingDifferentArmorCondition.CODEC);

    private BingoConditions() {
    }

    public static void load() {
    }

    private static RegistryValue<LootItemConditionType> register(String registryName, MapCodec<? extends LootItemCondition> codec) {
        return REGISTER.register(ResourceLocations.bingo(registryName), () -> new LootItemConditionType(codec));
    }
}

