/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoConditions;
import java.util.Set;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record BlockCondition(BlockPredicate block) implements LootItemCondition
{
    public static final MapCodec<BlockCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPredicate.CODEC.fieldOf("block").forGetter(BlockCondition::block)).apply((Applicative)instance, BlockCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.BLOCK.get();
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }

    public boolean test(LootContext lootContext) {
        BlockPos pos = BlockPos.containing((Position)((Position)lootContext.getParameter(LootContextParams.ORIGIN)));
        return this.block.matches(lootContext.getLevel(), pos);
    }

    public static Builder builder(BlockPredicate block) {
        return new Builder(block);
    }

    public static Builder builder(BlockPredicate.Builder blockBuilder) {
        return BlockCondition.builder(blockBuilder.build());
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final BlockPredicate block;

        private Builder(BlockPredicate block) {
            this.block = block;
        }

        @NotNull
        public LootItemCondition build() {
            return new BlockCondition(this.block);
        }
    }
}

