/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoConditions;
import io.github.gaming32.bingo.util.BingoCodecs;
import io.github.gaming32.bingo.util.BlockPattern;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class BlockPatternCondition
implements LootItemCondition {
    public static final MapCodec<BlockPatternCondition> CODEC = BingoCodecs.catchIAE(RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().listOf().fieldOf("aisles").forGetter(BlockPatternCondition::aisles), (App)Codec.unboundedMap(BingoCodecs.CHAR, (Codec)LocationPredicate.CODEC).fieldOf("where").forGetter(BlockPatternCondition::where), (App)BlockPattern.Rotations.CODEC.optionalFieldOf("rotations", (Object)BlockPattern.Rotations.HORIZONTAL).forGetter(BlockPatternCondition::rotations)).apply((Applicative)instance, BlockPatternCondition::new)));
    private final List<List<String>> aisles;
    private final Map<Character, LocationPredicate> where;
    private final BlockPattern.Rotations rotations;
    private final BlockPattern blockPattern;

    public BlockPatternCondition(List<List<String>> aisles, Map<Character, LocationPredicate> where, BlockPattern.Rotations rotations) {
        this.aisles = aisles;
        this.where = where;
        this.rotations = rotations;
        this.blockPattern = BlockPatternCondition.buildBlockPattern(aisles, where);
    }

    private static BlockPattern buildBlockPattern(List<List<String>> patternChars, Map<Character, LocationPredicate> where) {
        Map<Character, Predicate> predicates = where.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new BlockPredicateAdapter((LocationPredicate)e.getValue())));
        if (predicates.containsKey(Character.valueOf(' '))) {
            throw new IllegalArgumentException("Block predicate ' ' is predefined and may not be overridden");
        }
        return new BlockPattern((Predicate[][][])patternChars.stream().map(aisle -> {
            Predicate[][] aislePredicates = (Predicate[][])aisle.stream().map(row -> (Predicate[])row.chars().mapToObj(ch -> {
                Predicate predicate;
                Predicate predicate2 = predicate = ch == 32 ? blockInWorld -> true : (Predicate)predicates.get(Character.valueOf((char)ch));
                if (predicate == null) {
                    throw new IllegalArgumentException("Block pattern uses undefined char '" + (char)ch + "'");
                }
                return predicate;
            }).toArray(Predicate[]::new)).toArray(x$0 -> new Predicate[x$0][]);
            ArrayUtils.reverse((Object[])aislePredicates);
            return aislePredicates;
        }).toArray(x$0 -> new Predicate[x$0][][]));
    }

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.BLOCK_PATTERN.get();
    }

    public List<List<String>> aisles() {
        return this.aisles;
    }

    public Map<Character, LocationPredicate> where() {
        return this.where;
    }

    public BlockPattern.Rotations rotations() {
        return this.rotations;
    }

    public boolean test(LootContext lootContext) {
        ServerLevel level = lootContext.getLevel();
        BlockPos origin = BlockPos.containing((Position)((Position)lootContext.getParameter(LootContextParams.ORIGIN)));
        return this.blockPattern.find((LevelReader)level, origin, this.rotations);
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements LootItemCondition.Builder {
        private final ImmutableList.Builder<List<String>> aisles = ImmutableList.builder();
        private final ImmutableMap.Builder<Character, LocationPredicate> predicatesByChar = ImmutableMap.builder();
        private BlockPattern.Rotations rotations = BlockPattern.Rotations.HORIZONTAL;

        private Builder() {
        }

        public Builder aisle(String ... aisle) {
            this.aisles.add(List.of(aisle));
            return this;
        }

        public Builder where(char symbol, LocationPredicate predicate) {
            this.predicatesByChar.put((Object)Character.valueOf(symbol), (Object)predicate);
            return this;
        }

        public Builder where(char symbol, BlockPredicate.Builder block) {
            return this.where(symbol, LocationPredicate.Builder.location().setBlock(block).build());
        }

        public Builder rotations(BlockPattern.Rotations rotations) {
            this.rotations = rotations;
            return this;
        }

        @NotNull
        public BlockPatternCondition build() {
            return new BlockPatternCondition((List<List<String>>)this.aisles.build(), (Map<Character, LocationPredicate>)this.predicatesByChar.build(), this.rotations);
        }
    }

    record BlockPredicateAdapter(LocationPredicate predicate) implements Predicate<BlockInWorld>
    {
        @Override
        public boolean test(BlockInWorld blockInWorld) {
            LevelReader levelReader = blockInWorld.getLevel();
            if (!(levelReader instanceof ServerLevel)) {
                return false;
            }
            ServerLevel level = (ServerLevel)levelReader;
            return this.predicate.matches(level, (double)blockInWorld.getPos().getX() + 0.5, (double)blockInWorld.getPos().getY() + 0.5, (double)blockInWorld.getPos().getZ() + 0.5);
        }
    }
}

