/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.conditions.BingoConditions;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.core.Vec3i;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record DistanceFromSpawnCondition(Optional<DistancePredicate> distance) implements LootItemCondition
{
    public static final MapCodec<DistanceFromSpawnCondition> CODEC = DistancePredicate.CODEC.optionalFieldOf("distance").xmap(DistanceFromSpawnCondition::new, DistanceFromSpawnCondition::distance);

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.DISTANCE_FROM_SPAWN.get();
    }

    public boolean test(LootContext lootContext) {
        Vec3 origin = (Vec3)lootContext.getParameter(LootContextParams.ORIGIN);
        Vec3 spawnVec = Vec3.atCenterOf((Vec3i)lootContext.getLevel().getRespawnData().pos());
        return this.distance.isEmpty() || this.distance.get().matches(origin.x, origin.y, origin.z, spawnVec.x, spawnVec.y, spawnVec.z);
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }
}

