/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.conditions.BingoConditions;
import io.github.gaming32.bingo.mixin.common.BaseFireBlockAccessor;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public enum FlammableCondition implements LootItemCondition
{
    INSTANCE;

    public static final MapCodec<FlammableCondition> CODEC;

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.FLAMMABLE.get();
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }

    public boolean test(LootContext lootContext) {
        BlockPos pos = BlockPos.containing((Position)((Position)lootContext.getParameter(LootContextParams.ORIGIN)));
        return ((BaseFireBlockAccessor)Blocks.FIRE).callCanBurn(lootContext.getLevel().getBlockState(pos));
    }

    static {
        CODEC = MapCodec.unit((Object)((Object)INSTANCE));
    }
}

