/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.conditions.BingoConditions;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record InStructureCondition(TagKey<Structure> structure) implements LootItemCondition
{
    public static final MapCodec<InStructureCondition> CODEC = TagKey.hashedCodec((ResourceKey)Registries.STRUCTURE).fieldOf("structure").xmap(InStructureCondition::new, InStructureCondition::structure);

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.IN_STRUCTURE.get();
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }

    public boolean test(LootContext lootContext) {
        BlockPos pos = BlockPos.containing((Position)((Position)lootContext.getParameter(LootContextParams.ORIGIN)));
        return lootContext.getLevel().structureManager().getStructureWithPieceAt(pos, this.structure).isValid();
    }
}

