/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoConditions;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record OneByOneHoleCondition(int bottom, int top, BlockPredicate predicate) implements LootItemCondition
{
    public static final MapCodec<OneByOneHoleCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("bottom").forGetter(OneByOneHoleCondition::bottom), (App)Codec.INT.fieldOf("top").forGetter(OneByOneHoleCondition::top), (App)BlockPredicate.CODEC.fieldOf("predicate").forGetter(OneByOneHoleCondition::predicate)).apply((Applicative)instance, OneByOneHoleCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.ONE_BY_ONE_HOLE.get();
    }

    public boolean test(LootContext lootContext) {
        ServerLevel level = lootContext.getLevel();
        BlockPos.MutableBlockPos pos = BlockPos.containing((Position)((Position)lootContext.getParameter(LootContextParams.ORIGIN))).mutable();
        for (int y = this.bottom; y <= this.top; ++y) {
            if (this.predicate.test((Object)level, (Object)pos.setY(y))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }
}

