/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoConditions;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record PassengersCondition(List<ContextAwarePredicate> passengers, boolean requireFull) implements LootItemCondition
{
    public static final MapCodec<PassengersCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ContextAwarePredicate.CODEC.listOf().fieldOf("passengers").forGetter(PassengersCondition::passengers), (App)Codec.BOOL.optionalFieldOf("require_full", (Object)false).forGetter(PassengersCondition::requireFull)).apply((Applicative)instance, PassengersCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.PASSENGERS.get();
    }

    public boolean test(LootContext lootContext) {
        Entity thisEntity = (Entity)lootContext.getParameter(LootContextParams.THIS_ENTITY);
        if (thisEntity.getPassengers().size() < this.passengers.size()) {
            return false;
        }
        LinkedHashSet toTest = new LinkedHashSet(thisEntity.getPassengers());
        block0: for (ContextAwarePredicate passenger : this.passengers) {
            Iterator it = toTest.iterator();
            while (it.hasNext()) {
                Entity testPassenger = (Entity)it.next();
                LootParams subParams = new LootParams.Builder(lootContext.getLevel()).withParameter(LootContextParams.ORIGIN, (Object)((Vec3)lootContext.getParameter(LootContextParams.ORIGIN))).withParameter(LootContextParams.THIS_ENTITY, (Object)testPassenger).create(LootContextParamSets.ADVANCEMENT_ENTITY);
                LootContext subContext = new LootContext.Builder(subParams).create(Optional.empty());
                if (!passenger.matches(subContext)) continue;
                it.remove();
                continue block0;
            }
            return false;
        }
        return !this.requireFull || toTest.isEmpty();
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY, LootContextParams.ORIGIN);
    }
}

