/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoConditions;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record PillarCondition(int minHeight, Optional<BlockPredicate> block) implements LootItemCondition
{
    public static final MapCodec<PillarCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min_height").forGetter(PillarCondition::minHeight), (App)BlockPredicate.CODEC.optionalFieldOf("block").forGetter(PillarCondition::block)).apply((Applicative)instance, PillarCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.PILLAR.get();
    }

    public boolean test(LootContext lootContext) {
        ServerLevel level = lootContext.getLevel();
        BlockPos.MutableBlockPos pos = BlockPos.containing((Position)((Position)lootContext.getParameter(LootContextParams.ORIGIN))).mutable();
        BiPredicate<ServerLevel, BlockPos> predicate = this.block.isPresent() ? (arg_0, arg_1) -> ((BlockPredicate)this.block.get()).matches(arg_0, arg_1) : (l, b) -> !l.getBlockState(b).isAir();
        int height = 0;
        while (predicate.test(level, (BlockPos)pos)) {
            if (++height >= this.minHeight) {
                return true;
            }
            pos.move(0, 1, 0);
        }
        return false;
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }
}

