/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.conditions.BingoConditions;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public enum StairwayToHeavenCondition implements LootItemCondition
{
    INSTANCE;

    public static final MapCodec<StairwayToHeavenCondition> CODEC;

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.STAIRWAY_TO_HEAVEN.get();
    }

    public boolean test(LootContext lootContext) {
        Entity thisEntity = (Entity)lootContext.getParameter(LootContextParams.THIS_ENTITY);
        BlockPos origin = thisEntity.getOnPos();
        Level level = thisEntity.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockState originState = level2.getBlockState(origin);
        if (originState.is(BlockTags.STAIRS) && StairwayToHeavenCondition.scan(level2, origin, ((Direction)originState.getValue((Property)StairBlock.FACING)).getOpposite())) {
            return true;
        }
        return StairwayToHeavenCondition.scan(level2, origin.north(), Direction.NORTH) || StairwayToHeavenCondition.scan(level2, origin.south(), Direction.SOUTH) || StairwayToHeavenCondition.scan(level2, origin.east(), Direction.EAST) || StairwayToHeavenCondition.scan(level2, origin.west(), Direction.WEST);
    }

    private static boolean scan(ServerLevel level, BlockPos startPos, Direction direction) {
        ServerChunkCache chunkSource = level.getChunkSource();
        ChunkGenerator generator = chunkSource.getGenerator();
        RandomState randomState = chunkSource.randomState();
        Direction stairDirection = direction.getOpposite();
        BlockPos.MutableBlockPos currentPos = startPos.mutable();
        BlockState state;
        while ((state = level.getBlockState((BlockPos)currentPos)).is(BlockTags.STAIRS) && state.getValue((Property)StairBlock.FACING) == stairDirection && state.getValue((Property)StairBlock.HALF) == Half.BOTTOM) {
            currentPos.move(direction.getStepX(), -1, direction.getStepZ());
        }
        return generator.getFirstOccupiedHeight(currentPos.getX(), currentPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)level, randomState) >= currentPos.getY();
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY);
    }

    static {
        CODEC = MapCodec.unit((Object)((Object)INSTANCE));
    }
}

