/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.conditions.BingoConditions;
import java.util.Set;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record ToolIsEnchantedCondition(boolean nonCurse) implements LootItemCondition
{
    public static final MapCodec<ToolIsEnchantedCondition> CODEC = Codec.BOOL.optionalFieldOf("non_curse", (Object)false).xmap(ToolIsEnchantedCondition::new, ToolIsEnchantedCondition::nonCurse);

    public ToolIsEnchantedCondition() {
        this(false);
    }

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.TOOL_IS_ENCHANTED.get();
    }

    public boolean test(LootContext lootContext) {
        ItemStack tool = (ItemStack)lootContext.getParameter(LootContextParams.TOOL);
        if (!tool.isEnchanted()) {
            return false;
        }
        return !this.nonCurse || !tool.getEnchantments().keySet().stream().anyMatch(e -> e.is(EnchantmentTags.CURSE));
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.TOOL);
    }
}

