/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoConditions;
import io.github.gaming32.bingo.util.CustomEnumCodec;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record VillagerOwnershipCondition(PoiManager.Occupancy occupancy, Optional<TagPredicate<PoiType>> tag) implements LootItemCondition
{
    public static final MapCodec<VillagerOwnershipCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomEnumCodec.of(PoiManager.Occupancy.class).codec().fieldOf("occupancy").forGetter(VillagerOwnershipCondition::occupancy), (App)TagPredicate.codec((ResourceKey)Registries.POINT_OF_INTEREST_TYPE).optionalFieldOf("tag").forGetter(VillagerOwnershipCondition::tag)).apply((Applicative)instance, VillagerOwnershipCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.VILLAGER_OWNERSHIP.get();
    }

    public boolean test(LootContext lootContext) {
        return lootContext.getLevel().getPoiManager().getInChunk(type -> this.tag.isEmpty() || this.tag.get().matches(type), new ChunkPos(BlockPos.containing((Position)((Position)lootContext.getParameter(LootContextParams.ORIGIN)))), this.occupancy).anyMatch(r -> true);
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }
}

