/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoConditions;
import io.github.gaming32.bingo.data.tags.convention.ConventionItemTags;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record WearingDifferentArmorCondition(MinMaxBounds.Ints equippedArmor, MinMaxBounds.Ints differentTypes) implements LootItemCondition
{
    public static final MapCodec<WearingDifferentArmorCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinMaxBounds.Ints.CODEC.optionalFieldOf("equipped_armor", (Object)MinMaxBounds.Ints.ANY).forGetter(WearingDifferentArmorCondition::equippedArmor), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("different_types", (Object)MinMaxBounds.Ints.ANY).forGetter(WearingDifferentArmorCondition::differentTypes)).apply((Applicative)instance, WearingDifferentArmorCondition::new));

    @NotNull
    public LootItemConditionType getType() {
        return BingoConditions.WEARING_DIFFERENT_ARMOR.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.getParameter(LootContextParams.THIS_ENTITY);
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        int wearingCount = 0;
        HashSet models = HashSet.newHashSet(4);
        for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
            Equippable equippable;
            ItemStack stack = livingEntity.getItemBySlot(slot);
            if (!stack.is(ConventionItemTags.ARMORS) || (equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE)) == null) continue;
            equippable.assetId().ifPresent(models::add);
            ++wearingCount;
        }
        return this.equippedArmor.matches(wearingCount) && this.differentTypes.matches(models.size());
    }

    @NotNull
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY);
    }
}

