/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data;

import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.util.ResourceLocations;
import net.minecraft.Util;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class BingoDifficulties {
    public static final ResourceKey<BingoDifficulty> VERY_EASY = BingoDifficulties.createKey("very_easy");
    public static final ResourceKey<BingoDifficulty> EASY = BingoDifficulties.createKey("easy");
    public static final ResourceKey<BingoDifficulty> MEDIUM = BingoDifficulties.createKey("medium");
    public static final ResourceKey<BingoDifficulty> HARD = BingoDifficulties.createKey("hard");
    public static final ResourceKey<BingoDifficulty> VERY_HARD = BingoDifficulties.createKey("very_hard");

    private BingoDifficulties() {
    }

    public static void bootstrap(BootstrapContext<BingoDifficulty> context) {
        BingoDifficulties.register(context, VERY_EASY, 0);
        BingoDifficulties.register(context, EASY, 1);
        BingoDifficulties.register(context, MEDIUM, 2);
        BingoDifficulties.register(context, HARD, 3);
        BingoDifficulties.register(context, VERY_HARD, 4);
    }

    private static void register(BootstrapContext<BingoDifficulty> context, ResourceKey<BingoDifficulty> key, int number) {
        context.register(key, (Object)new BingoDifficulty((Component)Component.translatable((String)Util.makeDescriptionId((String)"bingo_difficulty", (ResourceLocation)key.location())), number));
    }

    private static ResourceKey<BingoDifficulty> createKey(String name) {
        return ResourceKey.create(BingoRegistries.DIFFICULTY, (ResourceLocation)ResourceLocations.bingo(name));
    }
}

