/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.util.BingoStreamCodecs;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatImmutableList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BingoTag(FloatList difficultyMax, boolean allowedOnSameLine, SpecialType specialType) {
    private static final Codec<FloatList> DIFFICULTY_MAX_CODEC = ExtraCodecs.nonEmptyList((Codec)Codec.FLOAT.validate(f -> f.floatValue() >= 0.0f && f.floatValue() <= 1.0f ? DataResult.success((Object)f) : DataResult.error(() -> "Value in difficulty_max must be in range [0,1]")).listOf()).xmap(FloatImmutableList::new, Function.identity());
    public static final Codec<BingoTag> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DIFFICULTY_MAX_CODEC.fieldOf("difficulty_max").forGetter(BingoTag::difficultyMax), (App)Codec.BOOL.optionalFieldOf("allowed_on_same_line", (Object)true).forGetter(BingoTag::allowedOnSameLine), (App)SpecialType.CODEC.optionalFieldOf("special_type", (Object)SpecialType.NONE).forGetter(BingoTag::specialType)).apply((Applicative)instance, BingoTag::new));

    public float getUnscaledMaxForDifficulty(int difficulty) {
        if (difficulty < 0) {
            throw new IllegalArgumentException("difficulty < 0 is invalid");
        }
        int size = this.difficultyMax.size();
        return difficulty < size ? this.difficultyMax.getFloat(difficulty) : this.difficultyMax.getFloat(size - 1);
    }

    public int getMaxForDifficulty(int difficulty, int goalCount) {
        return Mth.ceil((float)(this.getUnscaledMaxForDifficulty(difficulty) * (float)goalCount));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum SpecialType implements StringRepresentable
    {
        NONE(null),
        NEVER(0xFF5555),
        FINISH(0x5555FF);

        public static final StringRepresentable.EnumCodec<SpecialType> CODEC;
        public static final StreamCodec<FriendlyByteBuf, SpecialType> STREAM_CODEC;
        @Nullable
        public final Integer incompleteColor;

        private SpecialType(Integer incompleteColor) {
            this.incompleteColor = incompleteColor;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(SpecialType::values);
            STREAM_CODEC = BingoStreamCodecs.enum_(SpecialType.class);
        }
    }

    public static final class Builder {
        private FloatList difficultyMax = new FloatArrayList();
        private boolean allowedOnSameLine = true;
        private SpecialType specialType = SpecialType.NONE;

        private Builder() {
        }

        public Builder difficultyMax(int ... scaledBy5x5) {
            float[] unscaled = new float[scaledBy5x5.length];
            for (int i = 0; i < scaledBy5x5.length; ++i) {
                unscaled[i] = (float)scaledBy5x5[i] / 25.0f;
            }
            return this.difficultyMax(unscaled);
        }

        public Builder difficultyMax(float ... unscaledMaxes) {
            this.difficultyMax = FloatList.of((float[])unscaledMaxes);
            return this;
        }

        public Builder markerTag() {
            this.difficultyMax = FloatList.of((float)1.0f);
            return this;
        }

        public Builder disallowOnSameLine() {
            this.allowedOnSameLine = false;
            return this;
        }

        public Builder specialType(SpecialType specialType) {
            this.specialType = Objects.requireNonNull(specialType, "specialType");
            return this;
        }

        public BingoTag build() {
            return new BingoTag((FloatList)new FloatImmutableList(this.difficultyMax), this.allowedOnSameLine, this.specialType);
        }
    }
}

