/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data;

import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.util.ResourceLocations;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class BingoTags {
    public static final ResourceKey<BingoTag> ACTION = BingoTags.createKey("action");
    public static final ResourceKey<BingoTag> BUILD = BingoTags.createKey("build");
    public static final ResourceKey<BingoTag> COLOR = BingoTags.createKey("color");
    public static final ResourceKey<BingoTag> COMBAT = BingoTags.createKey("combat");
    public static final ResourceKey<BingoTag> END = BingoTags.createKey("end");
    public static final ResourceKey<BingoTag> FINISH = BingoTags.createKey("finish");
    public static final ResourceKey<BingoTag> ITEM = BingoTags.createKey("item");
    public static final ResourceKey<BingoTag> NETHER = BingoTags.createKey("nether");
    public static final ResourceKey<BingoTag> NEVER = BingoTags.createKey("never");
    public static final ResourceKey<BingoTag> OCEAN = BingoTags.createKey("ocean");
    public static final ResourceKey<BingoTag> OVERWORLD = BingoTags.createKey("overworld");
    public static final ResourceKey<BingoTag> RARE_BIOME = BingoTags.createKey("rare_biome");
    public static final ResourceKey<BingoTag> STAT = BingoTags.createKey("stat");
    public static final ResourceKey<BingoTag> VILLAGE = BingoTags.createKey("village");

    private BingoTags() {
    }

    public static void bootstrap(BootstrapContext<BingoTag> context) {
        context.register(ACTION, (Object)BingoTag.builder().difficultyMax(20, 20, 20, 20, 20).build());
        context.register(BUILD, (Object)BingoTag.builder().difficultyMax(20, 20, 20, 20, 20).build());
        context.register(COLOR, (Object)BingoTag.builder().difficultyMax(2, 2, 2, 2, 2).build());
        context.register(COMBAT, (Object)BingoTag.builder().difficultyMax(5, 10, 20, 20, 20).build());
        context.register(END, (Object)BingoTag.builder().difficultyMax(0, 0, 0, 1, 5).build());
        context.register(FINISH, (Object)BingoTag.builder().difficultyMax(1, 1, 1, 1, 1).disallowOnSameLine().specialType(BingoTag.SpecialType.FINISH).build());
        context.register(ITEM, (Object)BingoTag.builder().difficultyMax(25, 25, 20, 20, 20).build());
        context.register(NETHER, (Object)BingoTag.builder().difficultyMax(0, 2, 5, 10, 15).build());
        context.register(NEVER, (Object)BingoTag.builder().difficultyMax(3, 3, 3, 2, 1).disallowOnSameLine().specialType(BingoTag.SpecialType.NEVER).build());
        context.register(OCEAN, (Object)BingoTag.builder().difficultyMax(5, 5, 5, 5, 5).build());
        context.register(OVERWORLD, (Object)BingoTag.builder().difficultyMax(25, 25, 24, 21, 18).build());
        context.register(RARE_BIOME, (Object)BingoTag.builder().difficultyMax(0, 1, 2, 4, 6).build());
        context.register(STAT, (Object)BingoTag.builder().difficultyMax(5, 5, 5, 5, 5).build());
        context.register(VILLAGE, (Object)BingoTag.builder().difficultyMax(0, 1, 2, 3, 4).build());
    }

    private static ResourceKey<BingoTag> createKey(String name) {
        return ResourceKey.create(BingoRegistries.TAG, (ResourceLocation)ResourceLocations.bingo(name));
    }
}

