/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.goal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.goal.GoalBuilder;
import io.github.gaming32.bingo.data.icons.EmptyIcon;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.progresstrackers.EmptyProgressTracker;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTracker;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.ParsedOrSub;
import io.github.gaming32.bingo.data.subs.SubstitutionContext;
import io.github.gaming32.bingo.ext.CriterionTriggerExt;
import io.github.gaming32.bingo.util.BingoCodecs;
import io.github.gaming32.bingo.util.BingoUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;

public class BingoGoal {
    public static final Codec<BingoGoal> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, BingoSub.CODEC).optionalFieldOf("bingo_subs", Map.of()).forGetter(BingoGoal::getSubs), (App)Codec.unboundedMap((Codec)Codec.STRING, ParsedOrSub.codec(Criterion.CODEC)).fieldOf("criteria").forGetter(BingoGoal::getCriteria), (App)AdvancementRequirements.CODEC.optionalFieldOf("requirements").forGetter(g -> Optional.of(g.requirements)), (App)ProgressTracker.CODEC.optionalFieldOf("progress", (Object)EmptyProgressTracker.INSTANCE).forGetter(BingoGoal::getProgress), (App)ParsedOrSub.optionalCodec(ExtraCodecs.POSITIVE_INT, "required_count", 1).forGetter(BingoGoal::getRequiredCount), (App)RegistryCodecs.homogeneousList(BingoRegistries.TAG).optionalFieldOf("tags", (Object)HolderSet.empty()).forGetter(BingoGoal::getTags), (App)ParsedOrSub.codec(ComponentSerialization.CODEC).fieldOf("name").forGetter(BingoGoal::getName), (App)ParsedOrSub.codec(ComponentSerialization.CODEC).optionalFieldOf("tooltip").forGetter(BingoGoal::getTooltip), (App)ResourceLocation.CODEC.optionalFieldOf("tooltip_icon").forGetter(BingoGoal::getTooltipIcon), (App)ParsedOrSub.optionalCodec(GoalIcon.CODEC, "icon", EmptyIcon.INSTANCE).forGetter(BingoGoal::getIcon), (App)BingoCodecs.optionalPositiveInt("infrequency").forGetter(BingoGoal::getInfrequency), (App)BingoCodecs.minifiedSetField(Codec.STRING, "antisynergy").forGetter(BingoGoal::getAntisynergy), (App)BingoCodecs.minifiedSetField(Codec.STRING, "catalyst").forGetter(BingoGoal::getCatalyst), (App)BingoCodecs.minifiedSetField(Codec.STRING, "reactant").forGetter(BingoGoal::getReactant), (App)RegistryFixedCodec.create(BingoRegistries.DIFFICULTY).fieldOf("difficulty").forGetter(BingoGoal::getDifficulty), (App)RegistryOps.retrieveGetter((ResourceKey)Registries.TRIGGER_TYPE)).apply((Applicative)instance, BingoGoal::new)).validate(BingoGoal::validate);
    private final Map<String, BingoSub> subs;
    private final Map<String, ParsedOrSub<Criterion<?>>> criteria;
    private final AdvancementRequirements requirements;
    private final ProgressTracker progress;
    private final ParsedOrSub<Integer> requiredCount;
    private final HolderSet<BingoTag> tags;
    private final ParsedOrSub<Component> name;
    private final Optional<ParsedOrSub<Component>> tooltip;
    private final Optional<ResourceLocation> tooltipIcon;
    private final ParsedOrSub<GoalIcon> icon;
    private final OptionalInt infrequency;
    private final Set<String> antisynergy;
    private final Set<String> catalyst;
    private final Set<String> reactant;
    private final Holder<BingoDifficulty> difficulty;
    private final BingoTag.SpecialType specialType;
    private final boolean requiredOnClient;

    public BingoGoal(Map<String, BingoSub> subs, Map<String, ParsedOrSub<Criterion<?>>> criteria, Optional<AdvancementRequirements> requirements, ProgressTracker progress, ParsedOrSub<Integer> requiredCount, HolderSet<BingoTag> tags, ParsedOrSub<Component> name, Optional<ParsedOrSub<Component>> tooltip, Optional<ResourceLocation> tooltipIcon, ParsedOrSub<GoalIcon> icon, OptionalInt infrequency, Collection<String> antisynergy, Collection<String> catalyst, Collection<String> reactant, Holder<BingoDifficulty> difficulty, HolderGetter<CriterionTrigger<?>> triggerTypes) {
        this.subs = ImmutableMap.copyOf(subs);
        this.criteria = ImmutableMap.copyOf(criteria);
        this.requirements = requirements.orElseGet(() -> AdvancementRequirements.allOf(criteria.keySet()));
        this.progress = progress;
        this.requiredCount = requiredCount;
        this.tags = tags;
        this.name = name;
        this.tooltip = tooltip;
        this.tooltipIcon = tooltipIcon;
        this.icon = icon;
        this.infrequency = infrequency;
        this.antisynergy = ImmutableSet.copyOf(antisynergy);
        this.catalyst = ImmutableSet.copyOf(catalyst);
        this.reactant = ImmutableSet.copyOf(reactant);
        this.difficulty = difficulty;
        BingoTag.SpecialType specialType = BingoTag.SpecialType.NONE;
        for (Holder tag : tags) {
            if (((BingoTag)tag.value()).specialType() == BingoTag.SpecialType.NONE) continue;
            specialType = ((BingoTag)tag.value()).specialType();
            break;
        }
        this.specialType = specialType;
        boolean requiresClient = false;
        Codec triggerCodec = ResourceKey.codec((ResourceKey)Registries.TRIGGER_TYPE);
        for (ParsedOrSub<Criterion<?>> criterion : criteria.values()) {
            Optional trigger;
            ResourceKey triggerKey = criterion.serialized().get("trigger").read((Decoder)triggerCodec).result().orElse(null);
            if (triggerKey == null || !(trigger = triggerTypes.get(triggerKey)).isPresent() || !((CriterionTriggerExt)((Holder.Reference)trigger.get()).value()).bingo$requiresClientCode()) continue;
            requiresClient = true;
            break;
        }
        this.requiredOnClient = requiresClient;
    }

    public DataResult<BingoGoal> validate() {
        DataResult result = DataResult.success((Object)this);
        LinkedHashSet<String> availableSubs = LinkedHashSet.newLinkedHashSet(this.subs.size());
        SubstitutionContext substitutionContext = SubstitutionContext.createValidationContext(availableSubs);
        for (Map.Entry<String, BingoSub> sub : this.subs.entrySet()) {
            result = BingoUtil.combineError(result, sub.getValue().validate(substitutionContext));
            availableSubs.add(sub.getKey());
        }
        Codec triggerCodec = ResourceKey.codec((ResourceKey)Registries.TRIGGER_TYPE);
        for (ParsedOrSub<Criterion<?>> criterion : this.criteria.values()) {
            result = BingoUtil.combineError(result, criterion.serialized().get("trigger").read((Decoder)triggerCodec));
            result = BingoUtil.combineError(result, criterion.validate(substitutionContext));
        }
        result = BingoUtil.combineError(result, this.requirements.validate(this.criteria.keySet()));
        result = BingoUtil.combineError(result, this.progress.validate(this));
        result = BingoUtil.combineError(result, this.requiredCount.validate(substitutionContext));
        for (Holder tag : this.tags) {
            BingoTag.SpecialType type = ((BingoTag)tag.value()).specialType();
            if (type == BingoTag.SpecialType.NONE || type == this.specialType) continue;
            result = BingoUtil.combineError(result, () -> "Inconsistent specialTypes: " + String.valueOf((Object)type) + " does not match " + String.valueOf((Object)this.specialType));
        }
        result = BingoUtil.combineError(result, this.name.validate(substitutionContext));
        if (this.tooltip.isPresent()) {
            result = BingoUtil.combineError(result, this.tooltip.get().validate(substitutionContext));
        }
        result = BingoUtil.combineError(result, this.icon.validate(substitutionContext));
        if (this.specialType == BingoTag.SpecialType.FINISH && this.requirements.size() != 1) {
            result = BingoUtil.combineError(result, () -> "\"finish\" goals must have only ORed requirements");
        }
        return result;
    }

    public void validateParsedCriteria(ProblemReporter reporter, HolderGetter.Provider lootData) {
        this.criteria.forEach((key, criterionOrSub) -> criterionOrSub.ifParsed(criterion -> {
            CriterionValidator validator = new CriterionValidator(reporter.forChild((ProblemReporter.PathElement)new ProblemReporter.FieldPathElement(key)), lootData);
            criterion.triggerInstance().validate(validator);
        }));
    }

    public Map<String, BingoSub> getSubs() {
        return this.subs;
    }

    public Map<String, ParsedOrSub<Criterion<?>>> getCriteria() {
        return this.criteria;
    }

    public AdvancementRequirements getRequirements() {
        return this.requirements;
    }

    public ProgressTracker getProgress() {
        return this.progress;
    }

    public ParsedOrSub<Integer> getRequiredCount() {
        return this.requiredCount;
    }

    public HolderSet<BingoTag> getTags() {
        return this.tags;
    }

    public ParsedOrSub<Component> getName() {
        return this.name;
    }

    public Optional<ParsedOrSub<Component>> getTooltip() {
        return this.tooltip;
    }

    public Optional<ResourceLocation> getTooltipIcon() {
        return this.tooltipIcon;
    }

    public ParsedOrSub<GoalIcon> getIcon() {
        return this.icon;
    }

    public OptionalInt getInfrequency() {
        return this.infrequency;
    }

    public Set<String> getAntisynergy() {
        return this.antisynergy;
    }

    public Set<String> getCatalyst() {
        return this.catalyst;
    }

    public Set<String> getReactant() {
        return this.reactant;
    }

    public Holder<BingoDifficulty> getDifficulty() {
        return this.difficulty;
    }

    public BingoTag.SpecialType getSpecialType() {
        return this.specialType;
    }

    public boolean isRequiredOnClient() {
        return this.requiredOnClient;
    }

    public SubstitutionContext buildSubstitutionContext(RandomSource rand) {
        SubstitutionContext result = new SubstitutionContext(LinkedHashMap.newLinkedHashMap(this.subs.size()), rand);
        for (Map.Entry<String, BingoSub> entry : this.subs.entrySet()) {
            result.referable().put(entry.getKey(), entry.getValue().substitute(result));
        }
        return result.harden();
    }

    public MutableComponent buildName(SubstitutionContext context) {
        return BingoUtil.ensureHasFallback(this.name.substituteOrThrow(context).copy());
    }

    public Optional<Component> buildTooltip(SubstitutionContext context) {
        return this.tooltip.map(t -> BingoUtil.ensureHasFallback(((Component)t.substituteOrThrow(context)).copy()));
    }

    public GoalIcon buildIcon(SubstitutionContext context) {
        return this.icon.substituteOrThrow(context);
    }

    public Map<String, Criterion<?>> buildCriteria(SubstitutionContext context) {
        ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)this.criteria.size());
        for (Map.Entry<String, ParsedOrSub<Criterion<?>>> entry : this.criteria.entrySet()) {
            result.put((Object)entry.getKey(), entry.getValue().substituteOrThrow(context));
        }
        return result.build();
    }

    public int buildRequiredCount(SubstitutionContext context) {
        return this.requiredCount.substituteOrThrow(context);
    }

    public static GoalBuilder builder(ResourceLocation id) {
        return new GoalBuilder(id);
    }
}

