/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.goal;

import com.demonwav.mcdev.annotations.Translatable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.JsonSubber;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.data.icons.BlockIcon;
import io.github.gaming32.bingo.data.icons.EmptyIcon;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.progresstrackers.CriterionProgressTracker;
import io.github.gaming32.bingo.data.progresstrackers.EmptyProgressTracker;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTracker;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.ParsedOrSub;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public final class GoalBuilder {
    public static final ThreadLocal<DynamicOps<JsonElement>> JSON_OPS = ThreadLocal.withInitial(() -> JsonOps.INSTANCE);
    private static final ParsedOrSub<Integer> DEFAULT_REQUIRED_COUNT = ParsedOrSub.fromParsed(ExtraCodecs.POSITIVE_INT, 1);
    private static final ParsedOrSub<GoalIcon> DEFAULT_ICON = ParsedOrSub.fromParsed(GoalIcon.CODEC, EmptyIcon.INSTANCE);
    private final ResourceLocation id;
    private final ImmutableMap.Builder<String, BingoSub> subs = ImmutableMap.builder();
    private final ImmutableMap.Builder<String, ParsedOrSub<Criterion<?>>> criteria = ImmutableMap.builder();
    private Optional<AdvancementRequirements> requirements = Optional.empty();
    private ProgressTracker progress = EmptyProgressTracker.INSTANCE;
    private ParsedOrSub<Integer> requiredCount = DEFAULT_REQUIRED_COUNT;
    private AdvancementRequirements.Strategy requirementsStrategy = AdvancementRequirements.Strategy.AND;
    private final ImmutableSet.Builder<ResourceKey<BingoTag>> tags = ImmutableSet.builder();
    private Optional<ParsedOrSub<Component>> name = Optional.empty();
    private Optional<ParsedOrSub<Component>> tooltip = Optional.empty();
    private Optional<ResourceLocation> tooltipIcon = Optional.empty();
    private ParsedOrSub<GoalIcon> icon = DEFAULT_ICON;
    private OptionalInt infrequency = OptionalInt.empty();
    private ImmutableSet.Builder<String> antisynergy = ImmutableSet.builder();
    private final ImmutableSet.Builder<String> catalyst = ImmutableSet.builder();
    private final ImmutableSet.Builder<String> reactant = ImmutableSet.builder();
    private Optional<ResourceKey<BingoDifficulty>> difficulty;

    GoalBuilder(ResourceLocation id) {
        this.id = id;
    }

    public GoalBuilder sub(String key, BingoSub sub) {
        this.subs.put((Object)key, (Object)sub);
        return this;
    }

    public GoalBuilder criterion(String key, Criterion<?> criterion) {
        this.criteria.put((Object)key, ParsedOrSub.fromParsed(Criterion.CODEC, criterion, JSON_OPS.get()));
        return this;
    }

    public GoalBuilder criterion(String key, Criterion<?> criterion, Consumer<JsonSubber> subber) {
        JsonSubber json = new JsonSubber((JsonElement)Criterion.CODEC.encodeStart(JSON_OPS.get(), criterion).getOrThrow());
        subber.accept(json);
        this.criteria.put((Object)key, ParsedOrSub.parse(Criterion.CODEC, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json.json())));
        return this;
    }

    public GoalBuilder requirements(AdvancementRequirements requirements) {
        this.requirements = Optional.of(requirements);
        return this;
    }

    public GoalBuilder requirements(AdvancementRequirements.Strategy strategy) {
        this.requirementsStrategy = strategy;
        return this;
    }

    public GoalBuilder progress(ProgressTracker progress) {
        this.progress = progress;
        return this;
    }

    public GoalBuilder progress(String criterion) {
        return this.progress(CriterionProgressTracker.unscaled(criterion));
    }

    public GoalBuilder requiredCount(int requiredCount) {
        this.requiredCount = ParsedOrSub.fromParsed(ExtraCodecs.POSITIVE_INT, requiredCount, JSON_OPS.get());
        return this;
    }

    public GoalBuilder requiredCount(BingoSub requiredCountSub) {
        this.requiredCount = ParsedOrSub.fromSub(requiredCountSub, ExtraCodecs.POSITIVE_INT, JSON_OPS.get());
        return this;
    }

    @SafeVarargs
    public final GoalBuilder tags(ResourceKey<BingoTag> ... tags) {
        this.tags.add((Object[])tags);
        return this;
    }

    public GoalBuilder name(@Translatable(prefix="bingo.goal.") String name) {
        return this.name((Component)Component.translatable((String)("bingo.goal." + name)));
    }

    public GoalBuilder name(Component name) {
        this.name = Optional.of(ParsedOrSub.fromParsed(ComponentSerialization.CODEC, name, JSON_OPS.get()));
        return this;
    }

    public GoalBuilder name(Component name, Consumer<JsonSubber> subber) {
        JsonSubber json = new JsonSubber((JsonElement)ComponentSerialization.CODEC.encodeStart(JSON_OPS.get(), (Object)name).getOrThrow());
        subber.accept(json);
        this.name = Optional.of(ParsedOrSub.parse(ComponentSerialization.CODEC, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json.json())));
        return this;
    }

    public GoalBuilder tooltip(@Translatable(prefix="bingo.goal.", suffix=".tooltip") String tooltip) {
        return this.tooltip((Component)Component.translatable((String)("bingo.goal." + tooltip + ".tooltip")));
    }

    public GoalBuilder tooltip(Component tooltip) {
        this.tooltip = Optional.of(ParsedOrSub.fromParsed(ComponentSerialization.CODEC, tooltip, JSON_OPS.get()));
        return this;
    }

    public GoalBuilder tooltip(Component tooltip, Consumer<JsonSubber> subber) {
        JsonSubber json = new JsonSubber((JsonElement)ComponentSerialization.CODEC.encodeStart(JSON_OPS.get(), (Object)tooltip).getOrThrow());
        subber.accept(json);
        this.tooltip = Optional.of(ParsedOrSub.parse(ComponentSerialization.CODEC, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json.json())));
        return this;
    }

    public GoalBuilder tooltipIcon(ResourceLocation tooltipIcon) {
        this.tooltipIcon = Optional.of(tooltipIcon);
        return this;
    }

    public GoalBuilder icon(Object icon) {
        return this.icon(GoalIcon.infer(icon));
    }

    public GoalBuilder icon(Object icon, Consumer<JsonSubber> subber) {
        return this.icon(GoalIcon.infer(icon), subber);
    }

    public GoalBuilder icon(Block icon, ItemLike fallback) {
        return this.icon(BlockIcon.ofBlockAndItem(icon, fallback));
    }

    public GoalBuilder icon(Block icon, ItemLike fallback, Consumer<JsonSubber> subber) {
        return this.icon(BlockIcon.ofBlockAndItem(icon, fallback), subber);
    }

    public GoalBuilder icon(GoalIcon icon) {
        this.icon = ParsedOrSub.fromParsed(GoalIcon.CODEC, icon, JSON_OPS.get());
        return this;
    }

    public GoalBuilder icon(GoalIcon icon, Consumer<JsonSubber> subber) {
        JsonSubber jsonSubber = new JsonSubber((JsonElement)GoalIcon.CODEC.encodeStart(JSON_OPS.get(), (Object)icon).getOrThrow());
        subber.accept(jsonSubber);
        this.icon = ParsedOrSub.parse(GoalIcon.CODEC, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonSubber.json()));
        return this;
    }

    public GoalBuilder infrequency(int infrequency) {
        this.infrequency = OptionalInt.of(infrequency);
        return this;
    }

    public GoalBuilder setAntisynergy(String ... antisynergy) {
        this.antisynergy = ImmutableSet.builderWithExpectedSize((int)antisynergy.length);
        return this.antisynergy(antisynergy);
    }

    public GoalBuilder antisynergy(String ... antisynergy) {
        this.antisynergy.add((Object[])antisynergy);
        return this;
    }

    public GoalBuilder catalyst(String ... catalyst) {
        this.catalyst.add((Object[])catalyst);
        return this;
    }

    public GoalBuilder reactant(String ... reactant) {
        this.reactant.add((Object[])reactant);
        return this;
    }

    public GoalBuilder difficulty(ResourceKey<BingoDifficulty> difficulty) {
        this.difficulty = Optional.of(difficulty);
        return this;
    }

    public GoalHolder build(HolderLookup.Provider registries) {
        ImmutableMap criteria = this.criteria.build();
        return new GoalHolder(this.id, new BingoGoal((Map<String, BingoSub>)this.subs.buildOrThrow(), (Map<String, ParsedOrSub<Criterion<?>>>)criteria, this.requirements.or(() -> Optional.of(this.requirementsStrategy.create((Collection)criteria.keySet()))), this.progress, this.requiredCount, (HolderSet<BingoTag>)HolderSet.direct(arg_0 -> ((HolderLookup.RegistryLookup)registries.lookupOrThrow(BingoRegistries.TAG)).getOrThrow(arg_0), (Collection)this.tags.build()), this.name.orElseThrow(() -> new IllegalStateException("Bingo goal name has not been set")), this.tooltip, this.tooltipIcon, this.icon, this.infrequency, (Collection<String>)this.antisynergy.build(), (Collection<String>)this.catalyst.build(), (Collection<String>)this.reactant.build(), (Holder<BingoDifficulty>)registries.lookupOrThrow(BingoRegistries.DIFFICULTY).getOrThrow(this.difficulty.orElseThrow(() -> new IllegalStateException("Bingo goal difficulty has not been set"))), (HolderGetter<CriterionTrigger<?>>)registries.lookupOrThrow(Registries.TRIGGER_TYPE)));
    }
}

