/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.goal;

import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.subs.SubstitutionContext;
import io.github.gaming32.bingo.game.ActiveGoal;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public record GoalHolder(ResourceLocation id, BingoGoal goal) {
    public ActiveGoal build(RandomSource rand) {
        SubstitutionContext context = this.goal.buildSubstitutionContext(rand);
        Optional<Component> tooltip = this.goal.buildTooltip(context);
        MutableComponent name = this.goal.buildName(context);
        tooltip.ifPresent(t -> name.withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText(t))));
        return new ActiveGoal(this.id, (Component)name, tooltip, this.goal.getTooltipIcon(), this.goal.buildIcon(context), this.goal.buildCriteria(context), this.goal.buildRequiredCount(context), Optional.of(this.goal.getDifficulty()), this.goal.getRequirements(), this.goal.getSpecialType(), this.goal.getProgress());
    }

    @Override
    public String toString() {
        return this.id.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GoalHolder)) return false;
        GoalHolder h = (GoalHolder)obj;
        if (!this.id.equals((Object)h.id)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}

