/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.goal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.util.ResourceLocations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoalManager
extends SimpleJsonResourceReloadListener<BingoGoal> {
    public static final ResourceLocation ID = ResourceLocations.bingo("goals");
    private static Map<ResourceLocation, GoalHolder> goals = Map.of();
    private static Map<Integer, List<GoalHolder>> goalsByDifficulty = Map.of();
    private final HolderLookup.Provider registries;

    public GoalManager(HolderLookup.Provider registries) {
        super(registries, BingoGoal.CODEC, BingoRegistries.GOAL);
        this.registries = registries;
    }

    public static Set<ResourceLocation> getGoalIds() {
        return goals.keySet();
    }

    @Nullable
    public static GoalHolder getGoal(ResourceLocation id) {
        return goals.get(id);
    }

    public static List<GoalHolder> getGoalsByDifficulty(int difficulty) {
        if (difficulty < 0) {
            throw new IllegalArgumentException("Difficulties < 0 aren't allowed");
        }
        return goalsByDifficulty.getOrDefault(difficulty, List.of());
    }

    @NotNull
    public String getName() {
        return ID.toString();
    }

    protected void apply(Map<ResourceLocation, BingoGoal> goals, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)goals.size());
        HashMap<Integer, ImmutableList.Builder> byDifficulty = HashMap.newHashMap((int)this.registries.lookupOrThrow(BingoRegistries.DIFFICULTY).listElements().count());
        for (Map.Entry<ResourceLocation, BingoGoal> entry : goals.entrySet()) {
            BingoGoal goal = entry.getValue();
            GoalHolder holder = new GoalHolder(entry.getKey(), goal);
            this.validate(holder);
            result.put((Object)holder.id(), (Object)holder);
            byDifficulty.computeIfAbsent(((BingoDifficulty)goal.getDifficulty().value()).number(), k -> ImmutableList.builder()).add((Object)holder);
        }
        GoalManager.goals = result.build();
        goalsByDifficulty = (Map)byDifficulty.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ImmutableList.Builder)e.getValue()).build()));
        Bingo.LOGGER.info("Loaded {} bingo goals", (Object)GoalManager.goals.size());
    }

    private void validate(GoalHolder holder) {
        ProblemReporter.Collector collector = new ProblemReporter.Collector();
        holder.goal().validateParsedCriteria((ProblemReporter)collector, (HolderGetter.Provider)this.registries);
        if (!collector.isEmpty()) {
            Bingo.LOGGER.warn("Found validation problems in goal {}:\n{}", (Object)holder.id(), (Object)collector.getReport());
        }
    }
}

