/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.icons;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.icons.GoalIconType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public record CycleIcon(List<GoalIcon> icons) implements GoalIcon
{
    public static final MapCodec<CycleIcon> CODEC = ExtraCodecs.nonEmptyList((Codec)GoalIcon.CODEC.listOf()).fieldOf("icons").xmap(CycleIcon::new, CycleIcon::icons);
    public static final StreamCodec<RegistryFriendlyByteBuf, CycleIcon> STREAM_CODEC = GoalIcon.STREAM_CODEC.apply(ByteBufCodecs.list()).map(CycleIcon::new, CycleIcon::icons);

    public CycleIcon(List<GoalIcon> icons) {
        this.icons = icons = ImmutableList.copyOf(icons);
    }

    public CycleIcon(GoalIcon ... icons) {
        this((List<GoalIcon>)ImmutableList.copyOf((Object[])icons));
    }

    public static CycleIcon infer(Object ... icons) {
        return CycleIcon.infer(Arrays.stream(icons));
    }

    public static CycleIcon infer(Collection<?> icons) {
        return CycleIcon.infer(icons.stream());
    }

    public static CycleIcon infer(Iterable<?> icons) {
        return CycleIcon.infer(StreamSupport.stream(icons.spliterator(), false));
    }

    public static CycleIcon infer(Stream<?> icons) {
        return new CycleIcon((List)icons.map(GoalIcon::infer).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public ItemStack getFallback(RegistryAccess registries) {
        return this.icons.getLast().getFallback(registries);
    }

    @Override
    public GoalIconType<?> type() {
        return GoalIconType.CYCLE.get();
    }
}

