/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.icons;

import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.icons.GoalIconType;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;

public record EffectIcon(Holder<MobEffect> effect, Holder<Potion> potion) implements GoalIcon.WithoutContext
{
    public static final MapCodec<EffectIcon> CODEC = BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("effect").xmap(EffectIcon::of, EffectIcon::effect);
    public static final StreamCodec<RegistryFriendlyByteBuf, EffectIcon> STREAM_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT).map(EffectIcon::of, EffectIcon::effect);

    public static EffectIcon of(Holder<MobEffect> effect) {
        return new EffectIcon(effect, (Holder<Potion>)BuiltInRegistries.POTION.listElements().filter(p -> ((Potion)p.value()).getEffects().stream().anyMatch(e -> e.getEffect() == effect)).findFirst().map(h -> h).orElse(Potions.WATER));
    }

    @Override
    public ItemStack getFallback() {
        return PotionContents.createItemStack((Item)Items.POTION, this.potion);
    }

    @Override
    public GoalIconType<?> type() {
        return GoalIconType.EFFECT.get();
    }
}

