/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.icons;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.icons.GoalIconType;
import io.github.gaming32.bingo.util.BingoCodecs;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public record EntityIcon(EntityType<?> entity, CompoundTag data, ItemStack item) implements GoalIcon.WithoutContext
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<EntityIcon> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(EntityIcon::entity), (App)CompoundTag.CODEC.optionalFieldOf("data", (Object)new CompoundTag()).forGetter(EntityIcon::data), (App)BingoCodecs.LENIENT_ITEM_STACK.fieldOf("item").forGetter(EntityIcon::item)).apply((Applicative)instance, EntityIcon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EntityIcon> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), EntityIcon::entity, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, EntityIcon::data, (StreamCodec)ItemStack.STREAM_CODEC, EntityIcon::item, EntityIcon::new);

    public static EntityIcon ofSpawnEgg(EntityType<?> entity, CompoundTag data, int count) {
        return new EntityIcon(entity, data, new ItemStack((ItemLike)Objects.requireNonNull(SpawnEggItem.byId(entity), () -> "entity \"" + String.valueOf(entity) + "\" doesn't have a spawn egg"), count));
    }

    public static EntityIcon ofSpawnEgg(EntityType<?> entity, CompoundTag data) {
        return EntityIcon.ofSpawnEgg(entity, data, 1);
    }

    public static EntityIcon ofSpawnEgg(EntityType<?> entity, int count) {
        return EntityIcon.ofSpawnEgg(entity, new CompoundTag(), count);
    }

    public static EntityIcon ofSpawnEgg(EntityType<?> entity) {
        return EntityIcon.ofSpawnEgg(entity, new CompoundTag(), 1);
    }

    public static EntityIcon ofSpawnEgg(Entity entity, int count) {
        try (ProblemReporter.ScopedCollector collector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new ProblemReporter.FieldPathElement("data"), LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)collector, (HolderLookup.Provider)entity.registryAccess());
            entity.saveWithoutId((ValueOutput)output);
            EntityIcon entityIcon = EntityIcon.ofSpawnEgg(entity.getType(), output.buildResult(), count);
            return entityIcon;
        }
    }

    public static EntityIcon ofSpawnEgg(Entity entity) {
        return EntityIcon.ofSpawnEgg(entity, 1);
    }

    public static EntityIcon of(EntityType<?> entity, ItemStack item) {
        return new EntityIcon(entity, new CompoundTag(), item);
    }

    public static EntityIcon of(Entity entity, ItemStack item) {
        try (ProblemReporter.ScopedCollector collector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new ProblemReporter.FieldPathElement("data"), LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)collector, (HolderLookup.Provider)entity.registryAccess());
            entity.saveWithoutId((ValueOutput)output);
            EntityIcon entityIcon = new EntityIcon(entity.getType(), output.buildResult(), item);
            return entityIcon;
        }
    }

    @Override
    public ItemStack getFallback() {
        return this.item;
    }

    @Override
    public GoalIconType<?> type() {
        return GoalIconType.ENTITY.get();
    }
}

