/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.icons;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.icons.GoalIconType;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;

public record EntityTypeTagCycleIcon(TagKey<EntityType<?>> tag, Optional<Holder<Item>> baseItem, int count) implements GoalIcon.WithoutContext
{
    public static final MapCodec<EntityTypeTagCycleIcon> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("tag").forGetter(EntityTypeTagCycleIcon::tag), (App)Item.CODEC.optionalFieldOf("base_item").forGetter(EntityTypeTagCycleIcon::baseItem), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).forGetter(EntityTypeTagCycleIcon::count)).apply((Applicative)instance, EntityTypeTagCycleIcon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EntityTypeTagCycleIcon> STREAM_CODEC = StreamCodec.composite((StreamCodec)TagKey.streamCodec((ResourceKey)Registries.ENTITY_TYPE), EntityTypeTagCycleIcon::tag, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM).apply(ByteBufCodecs::optional), EntityTypeTagCycleIcon::baseItem, (StreamCodec)ByteBufCodecs.VAR_INT, EntityTypeTagCycleIcon::count, EntityTypeTagCycleIcon::new);

    public EntityTypeTagCycleIcon {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count must be positive");
    }

    public EntityTypeTagCycleIcon(TagKey<EntityType<?>> tag, Holder<Item> baseItem, int count) {
        this(tag, Optional.of(baseItem), count);
    }

    public EntityTypeTagCycleIcon(TagKey<EntityType<?>> tag, int count) {
        this(tag, Optional.empty(), count);
    }

    public EntityTypeTagCycleIcon(TagKey<EntityType<?>> tag, Holder<Item> baseItem) {
        this(tag, Optional.of(baseItem), 1);
    }

    public EntityTypeTagCycleIcon(TagKey<EntityType<?>> tag) {
        this(tag, Optional.empty(), 1);
    }

    @Override
    public ItemStack getFallback() {
        return new ItemStack(this.baseItem.orElseGet(() -> (Holder)StreamSupport.stream(BuiltInRegistries.ENTITY_TYPE.getTagOrEmpty(this.tag).spliterator(), false).map(holder -> SpawnEggItem.byId((EntityType)((EntityType)holder.value()))).filter(Objects::nonNull).findFirst().map(Item::builtInRegistryHolder).orElseGet(() -> ((Item)Items.AIR).builtInRegistryHolder())), this.count);
    }

    @Override
    public GoalIconType<?> type() {
        return GoalIconType.ENTITY_TYPE_TAG_CYCLE.get();
    }
}

