/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.icons;

import com.mojang.serialization.Codec;
import io.github.gaming32.bingo.data.icons.BlockIcon;
import io.github.gaming32.bingo.data.icons.EmptyIcon;
import io.github.gaming32.bingo.data.icons.EntityIcon;
import io.github.gaming32.bingo.data.icons.EntityTypeTagCycleIcon;
import io.github.gaming32.bingo.data.icons.GoalIconType;
import io.github.gaming32.bingo.data.icons.ItemIcon;
import io.github.gaming32.bingo.data.icons.ItemTagCycleIcon;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface GoalIcon {
    public static final Codec<GoalIcon> CODEC = GoalIconType.REGISTER.registry().byNameCodec().dispatch(GoalIcon::type, GoalIconType::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, GoalIcon> STREAM_CODEC = ByteBufCodecs.registry(GoalIconType.REGISTER.registryKey()).dispatch(GoalIcon::type, GoalIconType::streamCodec);

    public ItemStack getFallback(RegistryAccess var1);

    default public ItemStack getFallbackWithStaticContext() {
        return this.getFallback((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
    }

    public GoalIconType<?> type();

    public static GoalIcon infer(Object obj) {
        Object object = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GoalIcon.class, ItemStack.class, Block.class, BlockState.class, ItemLike.class, EntityType.class, TagKey.class}, (Object)object, n)) {
            case -1 -> EmptyIcon.INSTANCE;
            case 0 -> {
                GoalIcon icon = (GoalIcon)object;
                yield icon;
            }
            case 1 -> {
                ItemStack stack = (ItemStack)object;
                yield new ItemIcon(stack);
            }
            case 2 -> {
                Block block = (Block)object;
                yield BlockIcon.ofBlock(block);
            }
            case 3 -> {
                BlockState state = (BlockState)object;
                yield BlockIcon.ofBlock(state);
            }
            case 4 -> {
                ItemLike item = (ItemLike)object;
                yield ItemIcon.ofItem(item);
            }
            case 5 -> {
                EntityType entityType = (EntityType)object;
                yield EntityIcon.ofSpawnEgg(entityType);
            }
            case 6 -> {
                TagKey tagKey = (TagKey)object;
                if (tagKey.registry() == Registries.ITEM) {
                    yield new ItemTagCycleIcon((TagKey<Item>)tagKey);
                }
                if (tagKey.registry() == Registries.ENTITY_TYPE) {
                    yield new EntityTypeTagCycleIcon(tagKey);
                }
                throw new IllegalArgumentException("No TagCycleIcon for registry " + String.valueOf(tagKey.registry().location()));
            }
            default -> throw new IllegalArgumentException("Couldn't infer GoalIcon from " + String.valueOf(obj));
        };
    }

    public static interface WithoutContext
    extends GoalIcon {
        public ItemStack getFallback();

        @Override
        default public ItemStack getFallback(RegistryAccess registries) {
            return this.getFallback();
        }

        @Override
        default public ItemStack getFallbackWithStaticContext() {
            return this.getFallback();
        }
    }
}

