/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.icons;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.icons.GoalIconType;
import io.github.gaming32.bingo.util.BingoCodecs;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record InstrumentCycleIcon(Holder<Item> instrumentItem, OptionalInt overrideCount) implements GoalIcon
{
    public static final MapCodec<InstrumentCycleIcon> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.CODEC.fieldOf("instrument_item").forGetter(InstrumentCycleIcon::instrumentItem), (App)BingoCodecs.optionalPositiveInt("override_count").forGetter(InstrumentCycleIcon::overrideCount)).apply((Applicative)instance, InstrumentCycleIcon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, InstrumentCycleIcon> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), InstrumentCycleIcon::instrumentItem, (StreamCodec)ByteBufCodecs.OPTIONAL_VAR_INT, InstrumentCycleIcon::overrideCount, InstrumentCycleIcon::new);

    public InstrumentCycleIcon(Holder<Item> instrumentItem) {
        this(instrumentItem, OptionalInt.empty());
    }

    @Override
    public ItemStack getFallback(RegistryAccess registries) {
        Registry registry = registries.lookupOrThrow(Registries.INSTRUMENT);
        ItemStack result = registry.getAny().map(instrument -> InstrumentItem.create((Item)((Item)this.instrumentItem.value()), (Holder)instrument)).orElseGet(() -> new ItemStack(this.instrumentItem));
        result.setCount(Math.max(this.overrideCount.orElse(registry.size()), 1));
        return result;
    }

    @Override
    public GoalIconType<?> type() {
        return GoalIconType.INSTRUMENT_CYCLE.get();
    }
}

