/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.progresstrackers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTracker;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTrackerType;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoGame;
import net.minecraft.server.level.ServerPlayer;

public record CriterionProgressTracker(String criterion, float scale) implements ProgressTracker
{
    public static final MapCodec<CriterionProgressTracker> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("criterion").forGetter(CriterionProgressTracker::criterion), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(CriterionProgressTracker::scale)).apply((Applicative)instance, CriterionProgressTracker::new));

    public static CriterionProgressTracker unscaled(String criterion) {
        return new CriterionProgressTracker(criterion, 1.0f);
    }

    @Override
    public DataResult<ProgressTracker> validate(BingoGoal goal) {
        if (!goal.getCriteria().containsKey(this.criterion)) {
            return DataResult.error(() -> "Specified progress criterion '" + this.criterion + "' does not exist");
        }
        return DataResult.success((Object)this);
    }

    @Override
    public void goalProgressChanged(BingoGame game, ServerPlayer player, ActiveGoal goal, String criterion, int progress, int maxProgress) {
        if (!criterion.equals(this.criterion)) {
            return;
        }
        game.updateProgress(player, goal, (int)((float)progress * this.scale), (int)((float)maxProgress * this.scale));
    }

    @Override
    public ProgressTrackerType<?> type() {
        return ProgressTrackerType.CRITERION.get();
    }
}

