/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.progresstrackers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTrackerType;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.game.GoalProgress;
import net.minecraft.server.level.ServerPlayer;

public interface ProgressTracker {
    public static final Codec<ProgressTracker> CODEC = ProgressTrackerType.REGISTER.registry().byNameCodec().dispatch(ProgressTracker::type, ProgressTrackerType::codec);

    default public DataResult<ProgressTracker> validate(BingoGoal goal) {
        return DataResult.success((Object)this);
    }

    default public void goalProgressChanged(BingoGame game, ServerPlayer player, ActiveGoal goal, String criterion, int progress, int maxProgress) {
    }

    default public void criterionChanged(BingoGame game, ServerPlayer player, ActiveGoal goal, String criterion, boolean complete) {
    }

    default public void onGoalCompleted(BingoGame game, ServerPlayer player, ActiveGoal goal, int completedCount) {
        GoalProgress progress;
        if (completedCount < goal.requiredCount() && (progress = game.getGoalProgress(player, goal)) != null) {
            game.updateProgress(player, goal, 0, progress.maxProgress());
        }
    }

    public ProgressTrackerType<?> type();
}

