/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.progresstrackers.EmptyProgressTracker;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTracker;
import io.github.gaming32.bingo.util.BingoCodecs;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemLore;

public record ActiveGoal(ResourceLocation id, Component name, Optional<Component> tooltip, Optional<ResourceLocation> tooltipIcon, GoalIcon icon, Map<String, Criterion<?>> criteria, int requiredCount, Optional<Holder<BingoDifficulty>> difficulty, AdvancementRequirements requirements, BingoTag.SpecialType specialType, ProgressTracker progress) {
    public static final Codec<ActiveGoal> PERSISTENCE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ActiveGoal::id), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(ActiveGoal::name), (App)ComponentSerialization.CODEC.optionalFieldOf("tooltip").forGetter(ActiveGoal::tooltip), (App)ResourceLocation.CODEC.optionalFieldOf("tooltip_icon").forGetter(ActiveGoal::tooltipIcon), (App)GoalIcon.CODEC.fieldOf("icon").forGetter(ActiveGoal::icon), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Criterion.CODEC).fieldOf("criteria").forGetter(ActiveGoal::criteria), (App)Codec.INT.fieldOf("required_count").forGetter(ActiveGoal::requiredCount), (App)BingoCodecs.notOptional(RegistryFixedCodec.create(BingoRegistries.DIFFICULTY)).fieldOf("difficulty").forGetter(ActiveGoal::difficulty), (App)AdvancementRequirements.CODEC.fieldOf("requirements").forGetter(ActiveGoal::requirements), (App)BingoTag.SpecialType.CODEC.optionalFieldOf("special_type", (Object)BingoTag.SpecialType.NONE).forGetter(ActiveGoal::specialType), (App)ProgressTracker.CODEC.optionalFieldOf("progress", (Object)EmptyProgressTracker.INSTANCE).forGetter(ActiveGoal::progress)).apply((Applicative)instance, ActiveGoal::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ActiveGoal> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ActiveGoal::id, (StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC, ActiveGoal::name, (StreamCodec)ComponentSerialization.TRUSTED_OPTIONAL_STREAM_CODEC, ActiveGoal::tooltip, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs::optional), ActiveGoal::tooltipIcon, GoalIcon.STREAM_CODEC, ActiveGoal::icon, BingoTag.SpecialType.STREAM_CODEC, ActiveGoal::specialType, ActiveGoal::forClient);

    public static ActiveGoal forClient(ResourceLocation id, Component name, Optional<Component> tooltip, Optional<ResourceLocation> tooltipIcon, GoalIcon icon, BingoTag.SpecialType specialType) {
        return new ActiveGoal(id, name, tooltip, tooltipIcon, icon, Map.of(), 1, Optional.empty(), AdvancementRequirements.EMPTY, specialType, EmptyProgressTracker.INSTANCE);
    }

    public ItemStack getFallbackWithComponents(RegistryAccess access) {
        ItemStack result = this.icon.getFallback(access);
        result.set(DataComponents.ITEM_NAME, (Object)this.name);
        result.set(DataComponents.RARITY, (Object)Rarity.COMMON);
        if (result.getCount() > result.getMaxStackSize()) {
            result.set(DataComponents.MAX_STACK_SIZE, (Object)Math.min(result.getCount(), 99));
        }
        this.tooltip.ifPresent(component -> result.set(DataComponents.LORE, (Object)new ItemLore(List.of(component))));
        result.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers(List.of()));
        return result;
    }

    public void validateAndLog(HolderGetter.Provider lootData) {
        ProblemReporter.Collector collector = new ProblemReporter.Collector();
        this.validate((ProblemReporter)collector, lootData);
        if (!collector.isEmpty()) {
            Bingo.LOGGER.warn("Found validation problems in goal {}:\n{}", (Object)this.id, (Object)collector.getReport());
        }
    }

    private void validate(ProblemReporter reporter, HolderGetter.Provider lootData) {
        this.criteria.forEach((key, criterion) -> {
            CriterionValidator validator = new CriterionValidator(reporter.forChild((ProblemReporter.PathElement)new ProblemReporter.FieldPathElement(key)), lootData);
            criterion.triggerInstance().validate(validator);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ActiveGoal)) return false;
        ActiveGoal g = (ActiveGoal)obj;
        if (!this.id.equals((Object)g.id)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}

