/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.data.goal.GoalManager;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.game.BoardShape;
import io.github.gaming32.bingo.game.InvalidGoalException;
import io.github.gaming32.bingo.network.messages.both.ManualHighlightPayload;
import io.github.gaming32.bingo.util.BingoUtil;
import io.github.gaming32.bingo.util.ResourceLocations;
import io.github.gaming32.bingo.util.Vec2i;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class BingoBoard {
    public static final int DEFAULT_SIZE = 5;
    public static final int NUM_MANUAL_HIGHLIGHT_COLORS = 3;
    public static final Codec<BingoBoard> PERSISTENCE_CODEC = PartiallyParsed.CODEC.xmap(BingoBoard::create, PartiallyParsed::create);
    private final BoardShape shape;
    private final int size;
    private final Teams[] states;
    @Nullable
    private final Integer[][] manualHighlights;
    private final int[] manualHighlightModCount;
    private final ActiveGoal[] goals;
    private final Map<ResourceLocation, ActiveGoal> byVanillaId;
    private final Object2IntMap<ActiveGoal> toGoalIndex;

    private BingoBoard(BoardShape shape, int size, int teamCount) {
        this.shape = shape;
        this.size = size;
        int goalCount = shape.getGoalCount(size);
        this.states = new Teams[goalCount];
        this.manualHighlights = new Integer[teamCount][goalCount];
        this.manualHighlightModCount = new int[teamCount];
        this.goals = new ActiveGoal[goalCount];
        this.byVanillaId = HashMap.newHashMap(goalCount);
        this.toGoalIndex = new Object2IntOpenHashMap(goalCount);
        Arrays.fill(this.states, Teams.NONE);
        this.toGoalIndex.defaultReturnValue(-1);
    }

    private static BingoBoard create(PartiallyParsed parsed) {
        int size = parsed.size;
        int goalCount = parsed.shape.getGoalCount(size);
        BingoBoard board = new BingoBoard(parsed.shape, size, parsed.manualHighlights.size());
        parsed.states.toArray(board.states);
        parsed.goals.toArray(board.goals);
        for (int teamIndex = 0; teamIndex < parsed.manualHighlights.size(); ++teamIndex) {
            for (int i = 0; i < goalCount; ++i) {
                OptionalInt manualHighlight = parsed.manualHighlights.get(teamIndex).get(i);
                board.manualHighlights[teamIndex][i] = manualHighlight.isEmpty() ? null : Integer.valueOf(manualHighlight.getAsInt());
            }
        }
        for (int i = 0; i < goalCount; ++i) {
            ActiveGoal goal = board.goals[i];
            board.byVanillaId.put(BingoBoard.generateVanillaId(i), goal);
            board.toGoalIndex.put((Object)goal, i);
        }
        return board;
    }

    public static BingoBoard generate(BoardShape shape, int size, int difficulty, int teamCount, RandomSource rand, Predicate<GoalHolder> isAllowedGoal, Collection<GoalHolder> requiredGoals, HolderSet<BingoTag> excludedTags, boolean allowsClientRequired, HolderLookup.Provider registries) {
        int goalCount = shape.getGoalCount(size);
        BingoBoard board = new BingoBoard(shape, size, teamCount);
        GoalHolder[] generatedSheet = BingoBoard.generateGoals((HolderLookup<BingoDifficulty>)registries.lookupOrThrow(BingoRegistries.DIFFICULTY), shape, size, difficulty, rand, isAllowedGoal, requiredGoals, excludedTags, allowsClientRequired);
        for (int i = 0; i < goalCount; ++i) {
            ActiveGoal goal;
            try {
                goal = board.goals[i] = generatedSheet[i].build(rand);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidGoalException(generatedSheet[i].id(), (Throwable)e);
            }
            goal.validateAndLog((HolderGetter.Provider)registries);
            if (generatedSheet[i].goal().getSpecialType() == BingoTag.SpecialType.NEVER) {
                board.states[i] = Teams.fromAll(teamCount);
            }
            board.byVanillaId.put(BingoBoard.generateVanillaId(i), goal);
            board.toGoalIndex.put((Object)goal, i);
        }
        return board;
    }

    public static GoalHolder[] generateGoals(HolderLookup<BingoDifficulty> difficultyLookup, BoardShape shape, int size, int difficulty, RandomSource rand, Predicate<GoalHolder> isAllowedGoal, Collection<GoalHolder> requiredGoals, HolderSet<BingoTag> excludedTags, boolean allowsClientRequired) {
        ArrayDeque<GoalHolder> requiredGoalQueue = new ArrayDeque<GoalHolder>(requiredGoals);
        int goalCount = shape.getGoalCount(size);
        GoalHolder[] generatedSheet = new GoalHolder[goalCount];
        Int2ObjectOpenHashMap linesForCells = new Int2ObjectOpenHashMap();
        for (int[] line : shape.getLines(size)) {
            for (int cell : line) {
                ((List)linesForCells.computeIfAbsent(cell, k -> new ArrayList())).add(line);
            }
        }
        NavigableSet<Integer> difficulties = BingoDifficulty.getNumbers(difficultyLookup);
        int[] difficultyLayout = BingoBoard.generateDifficulty(difficulties, goalCount, difficulty, rand);
        int[] indices = BingoUtil.shuffle(BingoUtil.generateIntArray(goalCount), rand);
        HashSet usedGoals = HashSet.newHashSet(goalCount);
        Object2IntOpenHashMap tagCount = new Object2IntOpenHashMap();
        HashSet<String> antisynergys = new HashSet<String>();
        HashSet<String> reactants = new HashSet<String>();
        HashSet<String> catalysts = new HashSet<String>();
        for (Holder tag : excludedTags) {
            tagCount.put((Object)tag, ((BingoTag)tag.value()).getMaxForDifficulty(difficulty, goalCount));
        }
        for (int i = 0; i < goalCount; ++i) {
            GoalHolder goal;
            block15: {
                GoalHolder goalCandidate;
                Iterator<Integer> difficultiesToTry = difficulties.headSet(difficultyLayout[i], true).descendingIterator();
                if (!difficultiesToTry.hasNext()) {
                    throw new IllegalArgumentException("No goals with difficulty " + difficultyLayout[i] + " or easier");
                }
                difficultyLayout[i] = difficultiesToTry.next();
                List<GoalHolder> possibleGoals = GoalManager.getGoalsByDifficulty(difficultyLayout[i]);
                int failSafe = 0;
                block4: while (true) {
                    int infrequency2;
                    if (requiredGoalQueue.peek() != null) {
                        goal = (GoalHolder)requiredGoalQueue.remove();
                        break block15;
                    }
                    ++failSafe;
                    while (failSafe >= 500 || possibleGoals.isEmpty()) {
                        if (!difficultiesToTry.hasNext()) {
                            throw new IllegalArgumentException("No valid board layout was found for the specified size and difficulty");
                        }
                        difficultyLayout[i] = difficultiesToTry.next();
                        possibleGoals = GoalManager.getGoalsByDifficulty(difficultyLayout[i]);
                        failSafe = 1;
                    }
                    goalCandidate = possibleGoals.get(rand.nextInt(possibleGoals.size()));
                    if (!isAllowedGoal.test(goalCandidate) || !allowsClientRequired && goalCandidate.goal().isRequiredOnClient() || goalCandidate.goal().getInfrequency().isPresent() && rand.nextInt(infrequency2 = goalCandidate.goal().getInfrequency().getAsInt()) + 1 < infrequency2 || usedGoals.contains(goalCandidate.id())) continue;
                    if (goalCandidate.goal().getTags().size() != 0) {
                        for (Holder tag : goalCandidate.goal().getTags()) {
                            if (tagCount.getInt((Object)tag) < ((BingoTag)tag.value()).getMaxForDifficulty(difficulty, goalCount)) continue;
                            continue block4;
                        }
                        if (goalCandidate.goal().getTags().stream().anyMatch(t -> !((BingoTag)t.value()).allowedOnSameLine())) {
                            Iterator infrequency2 = ((List)linesForCells.get(indices[i])).iterator();
                            while (infrequency2.hasNext()) {
                                int[] line;
                                for (int cell : line = (int[])infrequency2.next()) {
                                    HolderSet<BingoTag> tags;
                                    if (cell != indices[i] && generatedSheet[cell] != null && (tags = generatedSheet[cell].goal().getTags()).size() > 0 && tags.stream().anyMatch(t -> !((BingoTag)t.value()).allowedOnSameLine() && goalCandidate.goal().getTags().contains(t))) continue block4;
                                }
                            }
                        }
                    }
                    if (Collections.disjoint(antisynergys, goalCandidate.goal().getAntisynergy()) && Collections.disjoint(reactants, goalCandidate.goal().getCatalyst()) && Collections.disjoint(catalysts, goalCandidate.goal().getReactant())) break;
                }
                goal = goalCandidate;
            }
            for (Holder tag : goal.goal().getTags()) {
                tagCount.addTo((Object)tag, 1);
            }
            antisynergys.addAll(goal.goal().getAntisynergy());
            catalysts.addAll(goal.goal().getCatalyst());
            reactants.addAll(goal.goal().getReactant());
            usedGoals.add(goal.id());
            generatedSheet[indices[i]] = goal;
        }
        return generatedSheet;
    }

    private static int[] generateDifficulty(NavigableSet<Integer> difficulties, int goalCount, int difficulty, RandomSource rand) {
        int[] layout = new int[goalCount];
        Iterator<Integer> available = difficulties.headSet(difficulty, true).descendingIterator();
        if (!available.hasNext()) {
            throw new IllegalArgumentException("No difficulty exists with number " + difficulty);
        }
        int difficulty1 = available.next();
        if (!available.hasNext()) {
            Arrays.fill(layout, difficulty1);
        } else {
            int difficulty2 = available.next();
            int amountOf1 = rand.nextInt(goalCount * 3 / 5, goalCount * 3 / 5 + (int)Math.sqrt(goalCount));
            int[] indices = BingoUtil.shuffle(BingoUtil.generateIntArray(goalCount), rand);
            Arrays.fill(layout, difficulty2);
            for (int i = 0; i < amountOf1; ++i) {
                layout[indices[i]] = difficulty1;
            }
        }
        return layout;
    }

    public BoardShape getShape() {
        return this.shape;
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    public Integer[] getTeamManualHighlights(Teams team) {
        Preconditions.checkArgument((boolean)team.one(), (Object)"Team must be a single team");
        return this.manualHighlights[team.getFirstIndex()];
    }

    public int getManualHighlightModCount(Teams team) {
        Preconditions.checkArgument((boolean)team.one(), (Object)"Team must be a single team");
        return this.manualHighlightModCount[team.getFirstIndex()];
    }

    public void setTeamManualHighlight(MinecraftServer server, BingoGame game, Teams team, int slot, @Nullable Integer value, @Nullable ServerPlayer cause) {
        Preconditions.checkArgument((boolean)team.one(), (Object)"Team must be a single team");
        int n = team.getFirstIndex();
        int n2 = this.manualHighlightModCount[n] + 1;
        this.manualHighlightModCount[n] = n2;
        int modCount = n2;
        this.manualHighlights[team.getFirstIndex()][slot] = value;
        ManualHighlightPayload clientboundPacket = new ManualHighlightPayload(slot, value == null ? 0 : value + 1, modCount);
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            Teams playerTeam;
            if (player == cause || !(playerTeam = game.getTeam(player)).and(team)) continue;
            clientboundPacket.sendTo(player);
        }
    }

    public Teams[] getStates() {
        return this.states;
    }

    public ActiveGoal[] getGoals() {
        return this.goals;
    }

    @Nullable
    public ActiveGoal byVanillaId(ResourceLocation id) {
        return this.byVanillaId.get(id);
    }

    public int getIndex(ActiveGoal goal) {
        return this.toGoalIndex.getInt((Object)goal);
    }

    public String toString() {
        int boxWidth = 20;
        int boxHeight = 7;
        Vec2i visualSize = this.shape.getVisualSize(this.size);
        StringBuilder result = new StringBuilder();
        for (int y = 0; y < visualSize.y(); ++y) {
            for (int column = 0; column < visualSize.x(); ++column) {
                result.append('+').repeat(45, 19);
            }
            result.append("+\n");
            String[][] texts = new String[visualSize.x()][];
            for (int x = 0; x < visualSize.x(); ++x) {
                int goalIndex = this.shape.getCellFromCoords(this.size, x, y);
                texts[x] = goalIndex == -1 ? new String[0] : WordUtils.wrap((String)this.goals[goalIndex].name().getString(), (int)17, (String)"\n", (boolean)true).split("\n");
            }
            for (int line = 0; line < 6; ++line) {
                for (int x = 0; x < visualSize.x(); ++x) {
                    String box = line < texts[x].length ? texts[x][line] : "";
                    result.append("| ").append(box).repeat(32, 20 - box.length() - 2);
                }
                result.append("|\n");
            }
        }
        for (int column = 0; column < visualSize.x(); ++column) {
            result.append('+').repeat(45, 19);
        }
        result.append('+');
        return result.toString();
    }

    public static ResourceLocation generateVanillaId(int index) {
        return ResourceLocations.bingo("generated/goal/" + index);
    }

    public static final class Teams {
        public static final Teams NONE = new Teams(0);
        public static final Teams TEAM1 = new Teams(1);
        public static final Teams TEAM2 = new Teams(2);
        private static final Teams[] CACHE = new Teams[]{NONE, TEAM1, TEAM2, new Teams(3)};
        public static final Codec<Teams> CODEC = Codec.INT.xmap(Teams::fromBits, Teams::toBits);
        public static final StreamCodec<ByteBuf, Teams> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(Teams::fromBits, Teams::toBits);
        private final int bits;

        private Teams(int bits) {
            this.bits = bits;
        }

        public static Teams fromBits(int bits) {
            if (bits >= 0 && bits < CACHE.length) {
                return CACHE[bits];
            }
            return new Teams(bits);
        }

        public static Teams fromOne(int index) {
            return Teams.fromBits(1 << index);
        }

        public static Teams fromAll(int count) {
            return Teams.fromBits((1 << count) - 1);
        }

        public int toBits() {
            return this.bits;
        }

        public boolean any() {
            return this.bits != 0;
        }

        public boolean all(int count) {
            return this.count() >= count;
        }

        public boolean one() {
            return this.count() == 1;
        }

        public int count() {
            return Integer.bitCount(this.bits);
        }

        public int getFirstIndex() {
            return Integer.numberOfTrailingZeros(this.bits);
        }

        public IntStream stream() {
            return IntStream.iterate(this.bits, i -> i != 0, i -> i & ~(1 << Integer.numberOfTrailingZeros(i))).map(Integer::numberOfTrailingZeros);
        }

        public Teams or(Teams other) {
            return Teams.fromBits(this.bits | other.bits);
        }

        public Teams andNot(Teams other) {
            return Teams.fromBits(this.bits & ~other.bits);
        }

        public boolean and(Teams other) {
            return (this.bits & other.bits) != 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Teams)) return false;
            Teams other = (Teams)obj;
            if (this.bits != other.bits) return false;
            return true;
        }

        public int hashCode() {
            return this.bits;
        }

        public String toString() {
            return "Teams[" + Integer.toBinaryString(this.bits) + "]";
        }
    }

    private record PartiallyParsed(BoardShape shape, int size, List<Teams> states, List<List<OptionalInt>> manualHighlights, List<ActiveGoal> goals) {
        static final Codec<PartiallyParsed> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)BoardShape.CODEC.optionalFieldOf("shape", (Object)BoardShape.SQUARE).forGetter(PartiallyParsed::shape), (App)ExtraCodecs.POSITIVE_INT.fieldOf("size").forGetter(PartiallyParsed::size), (App)Teams.CODEC.listOf().fieldOf("states").forGetter(PartiallyParsed::states), (App)Codec.INT.xmap(i -> i == 0 ? OptionalInt.empty() : OptionalInt.of(i - 1), i -> i.isEmpty() ? 0 : i.getAsInt() + 1).listOf().listOf().fieldOf("manual_highlights").forGetter(PartiallyParsed::manualHighlights), (App)ActiveGoal.PERSISTENCE_CODEC.listOf().fieldOf("goals").forGetter(PartiallyParsed::goals)).apply((Applicative)instance, PartiallyParsed::new)).validate(PartiallyParsed::validate);

        static PartiallyParsed create(BingoBoard board) {
            List<List<OptionalInt>> manualHighlights = Arrays.stream(board.manualHighlights).map(teamHighlights -> Arrays.stream(teamHighlights).map(i -> i == null ? OptionalInt.empty() : OptionalInt.of(i)).toList()).toList();
            return new PartiallyParsed(board.shape, board.size, List.of(board.states), manualHighlights, List.of(board.goals));
        }

        private DataResult<PartiallyParsed> validate() {
            int goalCount = this.shape.getGoalCount(this.size);
            DataResult result = DataResult.success((Object)this);
            result = BingoUtil.combineError(result, Util.fixedSize(this.states, (int)goalCount));
            result = BingoUtil.combineError(result, Util.fixedSize(this.goals, (int)goalCount));
            for (List<OptionalInt> teamHighlight : this.manualHighlights) {
                result = BingoUtil.combineError(result, Util.fixedSize(teamHighlight, (int)goalCount));
            }
            return result;
        }
    }
}

