/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.ext.ServerPlayerExt;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.GoalProgress;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import io.github.gaming32.bingo.mixin.common.PlayerAdvancementsAccessor;
import io.github.gaming32.bingo.network.VanillaNetworking;
import io.github.gaming32.bingo.network.messages.s2c.InitBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.RemoveBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.ResyncStatesPayload;
import io.github.gaming32.bingo.network.messages.s2c.SyncTeamPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateProgressPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateStatePayload;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.util.BingoCodecs;
import io.github.gaming32.bingo.util.BingoUtil;
import io.github.gaming32.bingo.util.StatCodecs;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoGame {
    public static final Component REQUIRED_CLIENT_KICK = Component.literal((String)"This bingo game requires the Bingo mod to be installed on the client. Please install it before joining.");
    public static final int DEFAULT_AUTO_FORFEIT_TICKS = 2400;
    private final BingoBoard board;
    private final BingoGameMode gameMode;
    private final boolean requireClient;
    private final boolean continueAfterWin;
    private final int autoForfeitTicks;
    private final PlayerTeam[] teams;
    private final Map<UUID, Map<ActiveGoal, AdvancementProgress>> advancementProgress = new HashMap<UUID, Map<ActiveGoal, AdvancementProgress>>();
    private final Map<UUID, Map<ActiveGoal, GoalProgress>> goalProgress = new HashMap<UUID, Map<ActiveGoal, GoalProgress>>();
    private final Map<UUID, Object2IntOpenHashMap<ActiveGoal>> goalAchievedCount = new HashMap<UUID, Object2IntOpenHashMap<ActiveGoal>>();
    private final Map<UUID, List<ActiveGoal>> queuedGoals = new HashMap<UUID, List<ActiveGoal>>();
    private final Map<UUID, Object2IntMap<Stat<?>>> baseStats = new HashMap();
    private final OptionalLong[] lastActiveTimes;
    private BingoBoard.Teams remainingTeams;
    private BingoBoard.Teams winningTeams = BingoBoard.Teams.NONE;
    private BingoBoard.Teams finishedTeams = BingoBoard.Teams.NONE;
    private BingoBoard.Teams nerfedTeams = BingoBoard.Teams.NONE;

    public BingoGame(BingoBoard board, BingoGameMode gameMode, boolean requireClient, boolean continueAfterWin, int autoForfeitTicks, PlayerTeam ... teams) {
        this.board = board;
        this.gameMode = gameMode;
        this.requireClient = requireClient;
        this.continueAfterWin = continueAfterWin;
        this.autoForfeitTicks = autoForfeitTicks;
        this.teams = teams;
        this.lastActiveTimes = new OptionalLong[teams.length];
        Arrays.fill(this.lastActiveTimes, OptionalLong.empty());
        this.remainingTeams = BingoBoard.Teams.fromAll(teams.length);
    }

    public BingoBoard getBoard() {
        return this.board;
    }

    public BingoGameMode getGameMode() {
        return this.gameMode;
    }

    public boolean isRequireClient() {
        return this.requireClient;
    }

    public boolean shouldContinueAfterWin() {
        return this.continueAfterWin;
    }

    public void addPlayer(ServerPlayer player) {
        Map<ActiveGoal, GoalProgress> goalProgress;
        if (this.requireClient && player.tickCount > 60 && !Bingo.isInstalledOnClient(player)) {
            player.connection.disconnect(REQUIRED_CLIENT_KICK);
            return;
        }
        RemoveBoardPayload.INSTANCE.sendTo(player);
        if (((ServerPlayerExt)player).bingo$clearAdvancementsNeedClearing()) {
            player.connection.send((Packet)new ClientboundUpdateAdvancementsPacket(false, List.of(), Set.of(VanillaNetworking.ROOT_ADVANCEMENT.id()), Map.of(), false));
        }
        this.registerListeners(player);
        BingoBoard.Teams team = this.getTeam(player);
        new SyncTeamPayload(team).sendTo(player);
        InitBoardPayload.create(this, team, this.obfuscateTeam(team, (Player)player)).sendTo(player);
        if (!((PlayerAdvancementsAccessor)player.getAdvancements()).getIsFirstPacket()) {
            this.syncAdvancementsTo(player);
        }
        if ((goalProgress = this.goalProgress.get(player.getUUID())) != null) {
            goalProgress.forEach((goal, progress) -> {
                int goalIndex = this.getBoardIndex(player, (ActiveGoal)goal);
                if (goalIndex != -1) {
                    new UpdateProgressPayload(goalIndex, progress.progress(), progress.maxProgress()).sendTo(player);
                }
            });
        }
    }

    public void syncAdvancementsTo(ServerPlayer player) {
        player.connection.send((Packet)new ClientboundUpdateAdvancementsPacket(false, VanillaNetworking.generateAdvancements(player.registryAccess(), this.board.getShape(), this.board.getSize(), this.board.getGoals()), Set.of(), VanillaNetworking.generateProgressMap(this.board.getStates(), this.getTeam(player)), false));
        ((ServerPlayerExt)player).bingo$markAdvancementsNeedClearing();
    }

    public void removePlayer(ServerPlayer player) {
        this.unregisterListeners(player, true);
    }

    public BingoBoard.Teams[] obfuscateTeam(BingoBoard.Teams playerTeam, Player player) {
        BingoBoard.Teams[] states = this.board.getStates();
        if (player != null && player.isSpectator()) {
            return states;
        }
        if (this.gameMode.getRenderMode() == BingoGameMode.RenderMode.ALL_TEAMS) {
            return states;
        }
        if (!playerTeam.any()) {
            Object[] ret = new BingoBoard.Teams[states.length];
            Arrays.fill(ret, BingoBoard.Teams.NONE);
            return ret;
        }
        BingoBoard.Teams[] result = new BingoBoard.Teams[states.length];
        for (int i = 0; i < states.length; ++i) {
            result[i] = BingoGame.obfuscateTeam(playerTeam, states[i]);
        }
        return result;
    }

    public static BingoBoard.Teams obfuscateTeam(BingoBoard.Teams playerTeam, BingoBoard.Teams state) {
        return state.and(playerTeam) ? playerTeam : BingoBoard.Teams.NONE;
    }

    public Object2IntMap<Stat<?>> getBaseStats(Player player) {
        return this.baseStats.getOrDefault(player.getUUID(), Object2IntMaps.emptyMap());
    }

    public Object2IntMap<Stat<?>> getOrCreateBaseStats(Player player) {
        return this.baseStats.computeIfAbsent(player.getUUID(), k -> new Object2IntOpenHashMap());
    }

    public void endGame(PlayerList playerList) {
        MutableComponent message;
        this.clearListeners(playerList);
        if (!this.winningTeams.any()) {
            this.winningTeams = this.getWinner(true);
        }
        if (!this.winningTeams.any()) {
            this.winningTeams = this.remainingTeams;
        }
        if (this.winningTeams.any()) {
            if (!this.winningTeams.one()) {
                message = Bingo.translatable("bingo.ended.tie", new Object[0]);
            } else {
                PlayerTeam playerTeam = this.getTeam(this.winningTeams);
                message = (Component)BingoUtil.mapEither(BingoUtil.getDisplayName(playerTeam, playerList), name -> {
                    if (playerTeam.getColor() != ChatFormatting.RESET) {
                        return name.copy().withStyle(playerTeam.getColor());
                    }
                    return name;
                }).map(playerName -> Bingo.translatable("bingo.ended.single", playerName), teamName -> Bingo.translatable("bingo.ended", teamName));
            }
            for (ServerPlayer player : playerList.getPlayers()) {
                player.playNotifySound(SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.MASTER, 1.0f, 1.0f);
            }
        } else {
            message = Bingo.translatable("bingo.ended.draw", new Object[0]);
        }
        playerList.broadcastSystemMessage((Component)message, false);
        ((MinecraftServerExt)playerList.getServer()).bingo$setGame(null);
        new ResyncStatesPayload(this.board.getStates()).sendTo(playerList.getPlayers());
        Bingo.updateCommandTree(playerList);
    }

    public void tick(MinecraftServer server) {
        if (this.requireClient) {
            for (ServerPlayer player : new ArrayList(server.getPlayerList().getPlayers())) {
                if (player.tickCount != 60 || Bingo.isInstalledOnClient(player)) continue;
                player.connection.disconnect(REQUIRED_CLIENT_KICK);
            }
        }
        if (this.autoForfeitTicks > 0 && server.getTickCount() % 20 == 0) {
            long gameTime = server.overworld().getGameTime();
            for (int i = 0; i < this.teams.length; ++i) {
                BingoBoard.Teams team = BingoBoard.Teams.fromOne(i);
                if (!this.remainingTeams.and(team)) continue;
                boolean isTeamActive = this.teams[i].getPlayers().stream().anyMatch(playerName -> server.getPlayerList().getPlayerByName(playerName) != null);
                if (isTeamActive) {
                    this.lastActiveTimes[i] = OptionalLong.of(gameTime);
                    continue;
                }
                OptionalLong lastActiveTime = this.lastActiveTimes[i];
                if (!lastActiveTime.isPresent() || gameTime - lastActiveTime.getAsLong() < (long)this.autoForfeitTicks) continue;
                this.forfeit(server.getPlayerList(), team);
            }
        }
    }

    public boolean forfeit(PlayerList playerList, BingoBoard.Teams team) {
        if (!this.remainingTeams.and(team)) {
            return false;
        }
        this.remainingTeams = this.remainingTeams.andNot(team);
        PlayerTeam playerTeam = this.getTeam(team);
        Component message = (Component)BingoUtil.mapEither(BingoUtil.getDisplayName(playerTeam, playerList), name -> {
            if (playerTeam.getColor() != ChatFormatting.RESET) {
                return name.copy().withStyle(playerTeam.getColor());
            }
            return name;
        }).map(playerName -> Bingo.translatable("bingo.forfeited.single", playerName), teamName -> Bingo.translatable("bingo.forfeited", teamName));
        playerList.broadcastSystemMessage(message, false);
        for (ServerPlayer player : playerList.getPlayers()) {
            player.playNotifySound((SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), SoundSource.MASTER, 1.0f, 1.0f);
        }
        if (this.remainingTeams.count() <= 1) {
            this.endGame(playerList);
        }
        return true;
    }

    private void registerListeners(ServerPlayer player) {
        for (ActiveGoal goal : this.board.getGoals()) {
            this.registerListeners(player, goal);
        }
    }

    private void clearListeners(PlayerList playerList) {
        for (Map.Entry<UUID, Map<ActiveGoal, AdvancementProgress>> playerEntry : this.advancementProgress.entrySet()) {
            ServerPlayer player = playerList.getPlayer(playerEntry.getKey());
            if (player == null) continue;
            for (ActiveGoal goal : playerEntry.getValue().keySet()) {
                this.unregisterListeners(player, goal, true);
            }
        }
    }

    private <T extends CriterionTriggerInstance> CriterionTrigger.Listener<T> createListener(Criterion<T> criterion, String criterionId, ActiveGoal goal) {
        return new CriterionTrigger.Listener(criterion.triggerInstance(), new AdvancementHolder(BingoBoard.generateVanillaId(this.board.getIndex(goal)), null), criterionId);
    }

    private <T extends CriterionTriggerInstance> void addListener(Criterion<T> criterion, String criterionId, ServerPlayer player, ActiveGoal goal) {
        criterion.trigger().addPlayerListener(player.getAdvancements(), this.createListener(criterion, criterionId, goal));
        CriterionTrigger criterionTrigger = criterion.trigger();
        if (criterionTrigger instanceof ProgressibleTrigger) {
            ProgressibleTrigger progressibleTrigger = (ProgressibleTrigger)criterionTrigger;
            progressibleTrigger.addProgressListener(player.getAdvancements(), new BingoGameProgressListener<CriterionTriggerInstance>(this, goal, player, criterionId, criterion.triggerInstance()));
        }
    }

    private <T extends CriterionTriggerInstance> void removeListener(Criterion<T> criterion, String criterionId, ServerPlayer player, ActiveGoal goal) {
        criterion.trigger().removePlayerListener(player.getAdvancements(), this.createListener(criterion, criterionId, goal));
        CriterionTrigger criterionTrigger = criterion.trigger();
        if (criterionTrigger instanceof ProgressibleTrigger) {
            ProgressibleTrigger progressibleTrigger = (ProgressibleTrigger)criterionTrigger;
            progressibleTrigger.removeProgressListener(player.getAdvancements(), new BingoGameProgressListener<CriterionTriggerInstance>(this, goal, player, criterionId, criterion.triggerInstance()));
        }
    }

    private void registerListeners(ServerPlayer player, ActiveGoal goal) {
        AdvancementProgress progress = this.getOrStartProgress(player, goal);
        if (!progress.isDone()) {
            for (Map.Entry<String, Criterion<?>> entry : goal.criteria().entrySet()) {
                CriterionProgress criterionProgress = progress.getCriterion(entry.getKey());
                if (criterionProgress == null || criterionProgress.isDone()) continue;
                this.addListener(entry.getValue(), entry.getKey(), player, goal);
            }
        }
    }

    private void unregisterListeners(ServerPlayer player, boolean force) {
        for (ActiveGoal goal : this.board.getGoals()) {
            this.unregisterListeners(player, goal, force);
        }
    }

    private void unregisterListeners(ServerPlayer player, ActiveGoal goal, boolean force) {
        AdvancementProgress progress = this.getOrStartProgress(player, goal);
        for (Map.Entry<String, Criterion<?>> entry : goal.criteria().entrySet()) {
            CriterionProgress criterionProgress = progress.getCriterion(entry.getKey());
            if (criterionProgress == null || !force && !criterionProgress.isDone() && !progress.isDone()) continue;
            this.removeListener(entry.getValue(), entry.getKey(), player, goal);
        }
    }

    public AdvancementProgress getOrStartProgress(ServerPlayer player, ActiveGoal goal) {
        Map map = this.advancementProgress.computeIfAbsent(player.getUUID(), k -> HashMap.newHashMap(this.board.getGoals().length));
        AdvancementProgress progress = (AdvancementProgress)map.get(goal);
        if (progress == null) {
            progress = new AdvancementProgress();
            progress.update(goal.requirements());
            map.put(goal, progress);
        }
        return progress;
    }

    @Nullable
    public GoalProgress getGoalProgress(ServerPlayer player, ActiveGoal goal) {
        Map<ActiveGoal, GoalProgress> progress = this.goalProgress.get(player.getUUID());
        return progress == null ? null : progress.get(goal);
    }

    public void updateProgress(ServerPlayer player, ActiveGoal goal, int progress, int maxProgress) {
        int goalIndex = this.getBoardIndex(player, goal);
        if (goalIndex == -1) {
            return;
        }
        Map goalProgress = this.goalProgress.computeIfAbsent(player.getUUID(), k -> HashMap.newHashMap(this.board.getGoals().length));
        GoalProgress existingProgress = (GoalProgress)goalProgress.get(goal);
        if (existingProgress != null && existingProgress.progress() == progress && existingProgress.maxProgress() == maxProgress) {
            return;
        }
        new UpdateProgressPayload(goalIndex, progress, maxProgress).sendTo(player);
        goalProgress.put(goal, new GoalProgress(progress, maxProgress));
    }

    public boolean award(ServerPlayer player, ActiveGoal goal, String criterion) {
        return this.award(player, goal, criterion, 1);
    }

    public boolean award(ServerPlayer player, ActiveGoal goal, String criterion, int count) {
        if (goal.specialType() == BingoTag.SpecialType.FINISH) {
            BingoBoard.Teams team = this.getTeam(player);
            BingoBoard.Teams[] board = this.board.getStates();
            int index = this.getBoardIndex(player, goal);
            if (index == -1) {
                return false;
            }
            BingoBoard.Teams oldTeams = board[index];
            board[index] = board[index].or(team);
            boolean winner = this.getWinner(false).and(team);
            board[index] = oldTeams;
            if (!winner) {
                return false;
            }
        }
        boolean awarded = false;
        AdvancementProgress progress = this.getOrStartProgress(player, goal);
        boolean wasDone = progress.isDone();
        if (progress.grantProgress(criterion)) {
            this.unregisterListeners(player, goal, false);
            awarded = true;
        }
        if (!wasDone && progress.isDone()) {
            int completedCount = this.goalAchievedCount.computeIfAbsent(player.getUUID(), k -> new Object2IntOpenHashMap()).addTo((Object)goal, count) + count;
            if (completedCount > goal.requiredCount()) {
                completedCount = goal.requiredCount();
            }
            goal.progress().onGoalCompleted(this, player, goal, completedCount);
            if (completedCount == goal.requiredCount()) {
                this.updateTeamBoard(player, goal, false);
            } else {
                for (String completedCriterion : progress.getCompletedCriteria()) {
                    progress.revokeProgress(completedCriterion);
                }
                this.unregisterListeners(player, goal, true);
                this.registerListeners(player, goal);
            }
        }
        goal.progress().criterionChanged(this, player, goal, criterion, true);
        return awarded;
    }

    public boolean award(ServerPlayer player, ActiveGoal goal) {
        AdvancementProgress progress = this.getOrStartProgress(player, goal);
        if (progress.isDone()) {
            return false;
        }
        boolean success = false;
        for (String criterion : progress.getRemainingCriteria()) {
            success |= this.award(player, goal, criterion, goal.requiredCount());
        }
        return success;
    }

    public boolean revoke(ServerPlayer player, ActiveGoal goal, String criterion) {
        boolean revoked = false;
        AdvancementProgress progress = this.getOrStartProgress(player, goal);
        boolean wasDone = progress.isDone();
        if (progress.revokeProgress(criterion)) {
            this.registerListeners(player, goal);
            revoked = true;
        }
        if (wasDone && !progress.isDone()) {
            this.updateTeamBoard(player, goal, true);
        }
        goal.progress().criterionChanged(this, player, goal, criterion, false);
        return revoked;
    }

    public boolean revoke(ServerPlayer player, ActiveGoal goal) {
        AdvancementProgress progress = this.getOrStartProgress(player, goal);
        if (!progress.hasProgress()) {
            return false;
        }
        boolean success = false;
        for (String criterion : progress.getCompletedCriteria()) {
            success |= this.revoke(player, goal, criterion);
        }
        Object2IntOpenHashMap<ActiveGoal> achievedCount = this.goalAchievedCount.get(player.getUUID());
        if (achievedCount != null) {
            achievedCount.removeInt((Object)goal);
        }
        return success;
    }

    public void flushQueuedGoals(ServerPlayer player) {
        List<ActiveGoal> goals = this.queuedGoals.remove(player.getUUID());
        if (goals == null) {
            return;
        }
        for (ActiveGoal goal : goals) {
            this.updateTeamBoard(player, goal, false);
        }
    }

    private void updateTeamBoard(ServerPlayer player, ActiveGoal goal, boolean revoke) {
        boolean isNever;
        BingoBoard.Teams team = this.getTeam(player);
        if (!team.any()) {
            if (!revoke) {
                this.queuedGoals.computeIfAbsent(player.getUUID(), k -> new ArrayList()).add(goal);
            }
            return;
        }
        if (!this.remainingTeams.and(team) && !this.finishedTeams.and(team)) {
            return;
        }
        if (!this.gameMode.canFinishedTeamsGetMoreGoals() && this.finishedTeams.and(team)) {
            return;
        }
        BingoBoard.Teams[] board = this.board.getStates();
        int index = this.getBoardIndex(player, goal);
        if (index == -1) {
            return;
        }
        boolean bl = isNever = goal.specialType() == BingoTag.SpecialType.NEVER;
        if (revoke || this.gameMode.canGetGoal(this.board, index, team, isNever)) {
            boolean isLoss = isNever ^ revoke;
            board[index] = isLoss ? board[index].andNot(team) : board[index].or(team);
            MinecraftServer server = player.level().getServer();
            this.notifyTeam(player, team, goal, server.getPlayerList(), index, isLoss);
            if (!isLoss) {
                this.checkForWin(server.getPlayerList());
            }
        }
    }

    private int getBoardIndex(ServerPlayer player, ActiveGoal goal) {
        int index = ArrayUtils.indexOf((Object[])this.board.getGoals(), (Object)goal);
        if (index == -1) {
            Bingo.LOGGER.warn("Player {} got a goal ({}) from a previous game! This should not happen.", (Object)player.getScoreboardName(), (Object)goal.id());
        }
        return index;
    }

    private void notifyTeam(ServerPlayer obtainer, BingoBoard.Teams team, ActiveGoal goal, PlayerList playerList, int boardIndex, boolean isLoss) {
        block6: {
            UpdateStatePayload statePayload;
            block5: {
                boolean announceGoal = this.gameMode.announceGoal(this, team, boardIndex);
                PlayerTeam playerTeam = this.getTeam(team);
                MutableComponent goalName = goal.name().copy().withStyle(isLoss ? ChatFormatting.GOLD : ChatFormatting.GREEN);
                MutableComponent message = playerTeam.getPlayers().size() == 1 ? Bingo.translatable(isLoss ? "bingo.goal_lost.single" : "bingo.goal_obtained.single", goalName) : Bingo.translatable(isLoss ? "bingo.goal_lost" : "bingo.goal_obtained", obtainer.getDisplayName(), goalName);
                BingoBoard.Teams boardState = this.board.getStates()[boardIndex];
                boolean showOtherTeam = this.gameMode.getRenderMode() == BingoGameMode.RenderMode.ALL_TEAMS;
                statePayload = new UpdateStatePayload(boardIndex, boardState);
                UpdateStatePayload obfuscatedStatePayload = new UpdateStatePayload(boardIndex, BingoGame.obfuscateTeam(team, boardState));
                ClientboundUpdateAdvancementsPacket vanillaPacket = new ClientboundUpdateAdvancementsPacket(false, List.of(), Set.of(), Map.of(BingoBoard.generateVanillaId(boardIndex), VanillaNetworking.generateProgress(boardState.and(team))), false);
                for (String member : playerTeam.getPlayers()) {
                    ServerPlayer player = playerList.getPlayerByName(member);
                    if (player == null) continue;
                    if (!showOtherTeam && !player.isSpectator()) {
                        obfuscatedStatePayload.sendTo(player);
                    }
                    player.connection.send((Packet)vanillaPacket);
                    if (!announceGoal) continue;
                    player.playNotifySound(isLoss ? (SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value() : (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.MASTER, isLoss ? 1.0f : 0.5f, 1.0f);
                    player.sendSystemMessage((Component)message);
                }
                if (!showOtherTeam) break block5;
                statePayload.sendTo(playerList.getPlayers());
                if (!this.gameMode.isLockout()) break block6;
                Component teamComponent = (Component)BingoUtil.getDisplayName(playerTeam, playerList).map(Function.identity(), Function.identity());
                if (playerTeam.getColor() != ChatFormatting.RESET) {
                    teamComponent = teamComponent.copy().withStyle(playerTeam.getColor());
                }
                MutableComponent lockoutMessage = Bingo.translatable("bingo.goal_lost.lockout", teamComponent, goal.name().copy().withStyle(ChatFormatting.GOLD));
                for (ServerPlayer player : playerList.getPlayers()) {
                    if (player.isAlliedTo((Team)playerTeam) || !announceGoal) continue;
                    player.playNotifySound((SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), SoundSource.MASTER, 0.5f, 1.0f);
                    player.sendSystemMessage((Component)lockoutMessage);
                }
                break block6;
            }
            for (ServerPlayer player : playerList.getPlayers()) {
                if (!player.isSpectator()) continue;
                statePayload.sendTo(player);
            }
        }
    }

    @NotNull
    public BingoBoard.Teams getTeam(ServerPlayer player) {
        for (int i = 0; i < this.teams.length; ++i) {
            if (!player.isAlliedTo((Team)this.teams[i])) continue;
            return BingoBoard.Teams.fromOne(i);
        }
        return BingoBoard.Teams.NONE;
    }

    public PlayerTeam getTeam(BingoBoard.Teams team) {
        if (!team.one()) {
            throw new IllegalArgumentException("BingoGame.getTeam() called with multiple teams!");
        }
        int index = team.getFirstIndex();
        if (index >= this.teams.length) {
            throw new IllegalArgumentException("BingoGame.getTeam() called with a team it doesn't have");
        }
        return this.teams[index];
    }

    public PlayerTeam[] getTeams() {
        return this.teams;
    }

    public BingoBoard.Teams getNerfedTeams() {
        return this.nerfedTeams;
    }

    public void nerfPlayer(ServerPlayer player) {
        BingoBoard.Teams team = this.getTeam(player);
        this.nerfedTeams = this.nerfedTeams.or(team);
    }

    public void checkForWin(PlayerList playerList) {
        BingoBoard.Teams finishers = this.getWinner(false);
        BingoBoard.Teams newFinishers = finishers.andNot(this.finishedTeams);
        if (!newFinishers.any()) {
            return;
        }
        int place = this.finishedTeams.count() + 1;
        this.finishedTeams = this.finishedTeams.or(finishers);
        if (place == 1) {
            this.winningTeams = newFinishers;
        }
        this.remainingTeams = this.remainingTeams.andNot(newFinishers);
        if (this.continueAfterWin) {
            this.notifyFinishedTeam(playerList, newFinishers, place);
        }
        if (!this.continueAfterWin || this.remainingTeams.count() < 2) {
            this.endGame(playerList);
        }
    }

    private void notifyFinishedTeam(PlayerList playerList, BingoBoard.Teams newFinishers, int place) {
        Component message;
        if (newFinishers.one()) {
            PlayerTeam playerTeam = this.getTeam(newFinishers);
            message = (Component)BingoUtil.mapEither(BingoUtil.getDisplayName(playerTeam, playerList), name -> {
                if (playerTeam.getColor() != ChatFormatting.RESET) {
                    return name.copy().withStyle(playerTeam.getColor());
                }
                return name;
            }).map(playerName -> Bingo.translatable("bingo.finished.single", playerName, BingoUtil.ordinal(place)), teamName -> Bingo.translatable("bingo.finished", teamName, BingoUtil.ordinal(place)));
        } else {
            MutableComponent teamList = ComponentUtils.wrapInSquareBrackets((Component)ComponentUtils.formatList(newFinishers.stream().mapToObj(teamIndex -> {
                PlayerTeam team = this.getTeam(BingoBoard.Teams.fromOne(teamIndex));
                Component name = (Component)Either.unwrap(BingoUtil.getDisplayName(team, playerList));
                if (team.getColor() != ChatFormatting.RESET) {
                    return name.copy().withStyle(team.getColor());
                }
                return name;
            }).toList(), Function.identity()));
            message = Bingo.translatable("bingo.finished.tie", teamList, BingoUtil.ordinal(place));
        }
        if (this.remainingTeams.count() > 1) {
            for (ServerPlayer player : playerList.getPlayers()) {
                player.playNotifySound(SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
        playerList.broadcastSystemMessage(message, false);
    }

    public BingoBoard.Teams getWinner(boolean tryHarder) {
        return this.gameMode.getWinners(this.board, this.teams.length, this.nerfedTeams, tryHarder);
    }

    public PersistenceData createPersistenceData() {
        return PersistenceData.create(this);
    }

    private record BingoGameProgressListener<T extends CriterionTriggerInstance>(BingoGame game, ActiveGoal goal, ServerPlayer player, String criterionId, T triggerInstance) implements ProgressibleTrigger.ProgressListener<T>
    {
        @Override
        public void update(T triggerInstance, int progress, int maxProgress) {
            if (triggerInstance == this.triggerInstance) {
                this.goal.progress().goalProgressChanged(this.game, this.player, this.goal, this.criterionId, progress, maxProgress);
            }
        }
    }

    public record PersistenceData(BingoBoard board, BingoGameMode gameMode, boolean requireClient, boolean continueAfterWin, int autoForfeitTicks, List<String> teamNames, Map<UUID, Int2ObjectMap<AdvancementProgress>> advancementProgress, Map<UUID, Int2ObjectMap<GoalProgress>> goalProgress, Map<UUID, Int2IntMap> goalAchievedCount, Map<UUID, IntList> queuedGoals, Map<UUID, Object2IntMap<Stat<?>>> baseStats, Optional<BingoBoard.Teams> playingTeams, BingoBoard.Teams winningTeams, BingoBoard.Teams finishedTeams, BingoBoard.Teams nerfedTeams) {
        private static final Codec<Map<UUID, Int2ObjectMap<AdvancementProgress>>> ADVANCEMENT_PROGRESS_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, BingoCodecs.int2ObjectMap(AdvancementProgress.CODEC));
        private static final Codec<Map<UUID, Int2ObjectMap<GoalProgress>>> GOAL_PROGRESS_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, BingoCodecs.int2ObjectMap(GoalProgress.PERSISTENCE_CODEC));
        private static final Codec<Map<UUID, Int2IntMap>> GOAL_ACHIEVED_COUNT_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, BingoCodecs.INT_2_INT_MAP);
        private static final Codec<Map<UUID, IntList>> QUEUED_GOALS_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, BingoCodecs.INT_LIST);
        private static final Codec<Map<UUID, Object2IntMap<Stat<?>>>> BASE_STATS_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, BingoCodecs.object2IntMap(StatCodecs.STRING_CODEC));
        public static final Codec<PersistenceData> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)BingoBoard.PERSISTENCE_CODEC.fieldOf("board").forGetter(PersistenceData::board), (App)BingoGameMode.PERSISTENCE_CODEC.fieldOf("game_mode").forGetter(PersistenceData::gameMode), (App)Codec.BOOL.fieldOf("require_client").forGetter(PersistenceData::requireClient), (App)Codec.BOOL.optionalFieldOf("continue_after_win", (Object)false).forGetter(PersistenceData::continueAfterWin), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("auto_forfeit_ticks", (Object)2400).forGetter(PersistenceData::autoForfeitTicks), (App)Codec.STRING.listOf().fieldOf("team_names").forGetter(PersistenceData::teamNames), (App)ADVANCEMENT_PROGRESS_CODEC.fieldOf("advancement_progress").forGetter(PersistenceData::advancementProgress), (App)GOAL_PROGRESS_CODEC.fieldOf("goal_progress").forGetter(PersistenceData::goalProgress), (App)GOAL_ACHIEVED_COUNT_CODEC.fieldOf("goal_achieved_count").forGetter(PersistenceData::goalAchievedCount), (App)QUEUED_GOALS_CODEC.fieldOf("queued_goals").forGetter(PersistenceData::queuedGoals), (App)BASE_STATS_CODEC.fieldOf("base_stats").forGetter(PersistenceData::baseStats), (App)BingoBoard.Teams.CODEC.optionalFieldOf("playing_teams").forGetter(PersistenceData::playingTeams), (App)BingoBoard.Teams.CODEC.optionalFieldOf("winning_teams", (Object)BingoBoard.Teams.NONE).forGetter(PersistenceData::winningTeams), (App)BingoBoard.Teams.CODEC.optionalFieldOf("finished_teams", (Object)BingoBoard.Teams.NONE).forGetter(PersistenceData::finishedTeams), (App)BingoBoard.Teams.CODEC.optionalFieldOf("nerfed_teams", (Object)BingoBoard.Teams.NONE).forGetter(PersistenceData::nerfedTeams)).apply((Applicative)instance, PersistenceData::new));

        public BingoGame createGame(Scoreboard scoreboard) throws IllegalStateException {
            Object subTarget;
            PlayerTeam[] teams = new PlayerTeam[this.teamNames.size()];
            for (int i = 0; i < teams.length; ++i) {
                teams[i] = scoreboard.getPlayerTeam(this.teamNames.get(i));
                if (teams[i] != null) continue;
                throw new IllegalStateException("Team '" + this.teamNames.get(i) + "' no longer exists");
            }
            BingoGame game = new BingoGame(this.board, this.gameMode, this.requireClient, this.continueAfterWin, this.autoForfeitTicks, teams);
            for (Map.Entry<UUID, Int2ObjectMap<AdvancementProgress>> entry : this.advancementProgress.entrySet()) {
                subTarget = HashMap.newHashMap(entry.getValue().size());
                for (Int2ObjectMap.Entry subEntry : entry.getValue().int2ObjectEntrySet()) {
                    ActiveGoal goal = this.getGoal(subEntry.getIntKey());
                    AdvancementProgress progress = (AdvancementProgress)subEntry.getValue();
                    progress.update(goal.requirements());
                    subTarget.put(goal, progress);
                }
                game.advancementProgress.put(entry.getKey(), (Map<ActiveGoal, AdvancementProgress>)subTarget);
            }
            for (Map.Entry<UUID, Object> entry : this.goalProgress.entrySet()) {
                subTarget = HashMap.newHashMap(((Int2ObjectMap)entry.getValue()).size());
                for (Int2ObjectMap.Entry subEntry : ((Int2ObjectMap)entry.getValue()).int2ObjectEntrySet()) {
                    subTarget.put(this.getGoal(subEntry.getIntKey()), (GoalProgress)subEntry.getValue());
                }
                game.goalProgress.put(entry.getKey(), (Map<ActiveGoal, GoalProgress>)subTarget);
            }
            for (Map.Entry<UUID, Object> entry : this.goalAchievedCount.entrySet()) {
                subTarget = new Object2IntOpenHashMap(((Int2IntMap)entry.getValue()).size());
                for (Int2ObjectMap.Entry subEntry : ((Int2IntMap)entry.getValue()).int2IntEntrySet()) {
                    subTarget.put((Object)this.getGoal(subEntry.getIntKey()), subEntry.getIntValue());
                }
                game.goalAchievedCount.put(entry.getKey(), (Object2IntOpenHashMap<ActiveGoal>)subTarget);
            }
            for (Map.Entry<UUID, Object> entry : this.queuedGoals.entrySet()) {
                subTarget = new ArrayList(((IntList)entry.getValue()).size());
                ObjectIterator objectIterator = ((IntList)entry.getValue()).iterator();
                while (objectIterator.hasNext()) {
                    int goal = (Integer)objectIterator.next();
                    subTarget.add(this.getGoal(goal));
                }
                game.queuedGoals.put(entry.getKey(), (List<ActiveGoal>)subTarget);
            }
            game.baseStats.putAll(this.baseStats);
            game.remainingTeams = this.playingTeams.orElseGet(() -> BingoBoard.Teams.fromAll(teams.length));
            game.winningTeams = this.winningTeams;
            game.finishedTeams = this.finishedTeams;
            return game;
        }

        private ActiveGoal getGoal(int goal) {
            return this.board.getGoals()[goal];
        }

        private static PersistenceData create(BingoGame game) {
            HashMap<UUID, Int2IntMap> goalAchievedCount = HashMap.newHashMap(game.goalAchievedCount.size());
            for (Map.Entry<UUID, Object2IntOpenHashMap<ActiveGoal>> entry : game.goalAchievedCount.entrySet()) {
                Int2IntOpenHashMap subTarget = new Int2IntOpenHashMap(entry.getValue().size());
                for (Object2IntMap.Entry subEntry : entry.getValue().object2IntEntrySet()) {
                    subTarget.put(PersistenceData.getGoal(game, (ActiveGoal)subEntry.getKey()), subEntry.getIntValue());
                }
                goalAchievedCount.put(entry.getKey(), (Int2IntMap)subTarget);
            }
            HashMap<UUID, IntList> queuedGoals = HashMap.newHashMap(game.queuedGoals.size());
            for (Map.Entry<UUID, List<ActiveGoal>> entry : game.queuedGoals.entrySet()) {
                IntArrayList subTarget = new IntArrayList(entry.getValue().size());
                for (ActiveGoal value : entry.getValue()) {
                    subTarget.add(PersistenceData.getGoal(game, value));
                }
                queuedGoals.put(entry.getKey(), (IntList)subTarget);
            }
            return new PersistenceData(game.board, game.gameMode, game.requireClient, game.continueAfterWin, game.autoForfeitTicks, Arrays.stream(game.teams).map(PlayerTeam::getName).toList(), PersistenceData.createMap(game, game.advancementProgress), PersistenceData.createMap(game, game.goalProgress), goalAchievedCount, queuedGoals, game.baseStats, Optional.of(game.remainingTeams), game.winningTeams, game.finishedTeams, game.nerfedTeams);
        }

        private static <V> Map<UUID, Int2ObjectMap<V>> createMap(BingoGame game, Map<UUID, Map<ActiveGoal, V>> source) {
            HashMap<UUID, Int2ObjectMap<Int2ObjectOpenHashMap>> target = HashMap.newHashMap(source.size());
            for (Map.Entry<UUID, Map<ActiveGoal, V>> entry : source.entrySet()) {
                Int2ObjectOpenHashMap subTarget = new Int2ObjectOpenHashMap(entry.getValue().size());
                for (Map.Entry<ActiveGoal, V> subEntry : entry.getValue().entrySet()) {
                    subTarget.put(PersistenceData.getGoal(game, subEntry.getKey()), subEntry.getValue());
                }
                target.put(entry.getKey(), (Int2ObjectMap<Int2ObjectOpenHashMap>)subTarget);
            }
            return target;
        }

        private static int getGoal(BingoGame game, ActiveGoal goal) {
            return game.board.getIndex(goal);
        }
    }
}

