/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game.mode;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.game.mode.BlackoutGameMode;
import io.github.gaming32.bingo.game.mode.LockoutGameMode;
import io.github.gaming32.bingo.game.mode.StandardGameMode;
import io.github.gaming32.bingo.platform.registry.DeferredRegister;
import io.github.gaming32.bingo.platform.registry.RegistryBuilder;
import io.github.gaming32.bingo.platform.registry.RegistryValue;
import io.github.gaming32.bingo.util.BingoStreamCodecs;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BingoGameMode {
    public static final DeferredRegister<BingoGameMode> REGISTER = new RegistryBuilder<BingoGameMode>(BingoRegistries.GAME_MODE).defaultId("standard").build();
    public static final RegistryValue<BingoGameMode> STANDARD = REGISTER.register("standard", StandardGameMode::new);
    public static final RegistryValue<BingoGameMode> LOCKOUT = REGISTER.register("lockout", LockoutGameMode::new);
    public static final RegistryValue<BingoGameMode> BLACKOUT = REGISTER.register("blackout", BlackoutGameMode::new);
    public static final Codec<BingoGameMode> PERSISTENCE_CODEC = REGISTER.registry().byNameCodec();

    @Nullable
    default public CommandSyntaxException checkAllowedConfig(GameConfig config) {
        return null;
    }

    public @NotNull BingoBoard.Teams getWinners(BingoBoard var1, int var2, BingoBoard.Teams var3, boolean var4);

    public boolean canGetGoal(BingoBoard var1, int var2, BingoBoard.Teams var3, boolean var4);

    default public boolean isGoalAllowed(GoalHolder goal) {
        return true;
    }

    default public boolean announceGoal(BingoGame game, BingoBoard.Teams team, int goalIndex) {
        return game.getNerfedTeams().and(team) || !game.getBoard().getShape().isNerfCell(game.getBoard().getSize(), goalIndex);
    }

    default public RenderMode getRenderMode() {
        return RenderMode.FANCY;
    }

    default public boolean isLockout() {
        return false;
    }

    default public boolean canFinishedTeamsGetMoreGoals() {
        return true;
    }

    public static boolean hasGoal(BingoBoard board, int goalIndex, BingoBoard.Teams team, boolean isNerfed) {
        if (!isNerfed && board.getShape().isNerfCell(board.getSize(), goalIndex)) {
            return true;
        }
        return board.getStates()[goalIndex].and(team);
    }

    public static void load() {
    }

    public static enum RenderMode {
        FANCY,
        ALL_TEAMS;

        public static final StreamCodec<FriendlyByteBuf, RenderMode> STREAM_CODEC;

        static {
            STREAM_CODEC = BingoStreamCodecs.enum_(RenderMode.class);
        }
    }

    public record GameConfig(BingoGameMode gameMode, int size, Collection<PlayerTeam> teams) {
    }
}

