/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game.mode;

import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import org.jetbrains.annotations.NotNull;

public class BlackoutGameMode
implements BingoGameMode {
    @Override
    @NotNull
    public BingoBoard.Teams getWinners(BingoBoard board, int teamCount, BingoBoard.Teams nerfedTeams, boolean tryHarder) {
        BingoBoard.Teams result = BingoBoard.Teams.NONE;
        for (int i = 0; i < teamCount; ++i) {
            BingoBoard.Teams team = BingoBoard.Teams.fromOne(i);
            if (!this.hasWon(board, team, nerfedTeams.and(team))) continue;
            result = result.or(team);
        }
        return result;
    }

    private boolean hasWon(BingoBoard board, BingoBoard.Teams team, boolean isNerfed) {
        int goalCount = board.getShape().getGoalCount(board.getSize());
        for (int goalIndex = 0; goalIndex < goalCount; ++goalIndex) {
            if (BingoGameMode.hasGoal(board, goalIndex, team, isNerfed)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canGetGoal(BingoBoard board, int index, BingoBoard.Teams team, boolean isNever) {
        return !board.getStates()[index].and(team);
    }

    @Override
    public boolean isGoalAllowed(GoalHolder goal) {
        return goal.goal().getTags().stream().allMatch(g -> ((BingoTag)g.value()).specialType() == BingoTag.SpecialType.NONE);
    }
}

