/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game.persistence;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.game.persistence.PersistenceDataFixers;
import io.github.gaming32.bingo.game.persistence.PersistenceTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.scores.Scoreboard;

public class PersistenceManager {
    public static final int CURRENT_DATA_VERSION = 4;

    public static CompoundTag serialize(HolderLookup.Provider registries, BingoGame game) {
        BingoGame.PersistenceData data = game.createPersistenceData();
        Tag tag = (Tag)BingoGame.PersistenceData.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)data).getOrThrow();
        if (!(tag instanceof CompoundTag)) {
            throw new IllegalStateException("Bingo game didn't serialize to CompoundTag");
        }
        CompoundTag compound = (CompoundTag)tag;
        NbtUtils.addDataVersion((CompoundTag)compound, (int)4);
        return compound;
    }

    public static BingoGame deserialize(HolderLookup.Provider registries, CompoundTag tag, Scoreboard scoreboard) {
        int version = NbtUtils.getDataVersion((CompoundTag)tag, (int)1);
        Tag newTag = (Tag)PersistenceDataFixers.getDataFixer().update(PersistenceTypes.GAME, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag), version, 4).getValue();
        BingoGame.PersistenceData data = (BingoGame.PersistenceData)BingoGame.PersistenceData.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)newTag).getOrThrow();
        return data.createGame(scoreboard);
    }
}

