/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game.persistence.fixes;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import io.github.gaming32.bingo.game.persistence.PersistenceTypes;

public class FlattenGoalFix
extends DataFix {
    public FlattenGoalFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type input = this.getInputSchema().getType(PersistenceTypes.ACTIVE_GOAL);
        Type output = this.getOutputSchema().getType(PersistenceTypes.ACTIVE_GOAL);
        return this.writeFixAndRead("FlattenGoalFix", input, output, this::fix);
    }

    private Dynamic<?> fix(Dynamic<?> goal) {
        Dynamic holder = goal.get("goal").orElseEmptyMap();
        Dynamic realGoal = holder.get("goal").orElseEmptyMap();
        goal = goal.remove("goal");
        goal = FlattenGoalFix.copyFieldFrom(goal, holder, "id");
        goal = FlattenGoalFix.copyFieldFrom(goal, realGoal, "tooltip_icon");
        goal = FlattenGoalFix.copyFieldFrom(goal, realGoal, "difficulty");
        goal = FlattenGoalFix.copyFieldFrom(goal, realGoal, "requirements");
        goal = FlattenGoalFix.copyFieldFrom(goal, realGoal, "special_type");
        goal = FlattenGoalFix.copyFieldFrom(goal, realGoal, "progress");
        return goal;
    }

    private static Dynamic<?> copyFieldFrom(Dynamic<?> result, Dynamic<?> from, String field) {
        return result.setFieldIfPresent(field, from.get(field).result());
    }
}

