/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game.persistence.schemas;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TypeTemplate;
import io.github.gaming32.bingo.game.persistence.PersistenceTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class BingoV2
extends NamespacedSchema {
    public BingoV2(int versionKey, Schema parent) {
        super(versionKey, parent);
    }

    public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
        super.registerTypes(schema, entityTypes, blockEntityTypes);
        schema.registerType(false, PersistenceTypes.CRITERION, () -> DSL.or((TypeTemplate)DSL.taggedChoiceLazy((String)"trigger", (Type)BingoV2.namespacedString(), (Map)entityTypes), (TypeTemplate)DSL.remainder()));
        schema.registerType(true, PersistenceTypes.ICON, () -> DSL.or((TypeTemplate)DSL.taggedChoiceLazy((String)"type", (Type)BingoV2.namespacedString(), (Map)blockEntityTypes), (TypeTemplate)DSL.remainder()));
        schema.registerType(false, PersistenceTypes.ACTIVE_GOAL, () -> DSL.fields((String)"icon", (TypeTemplate)PersistenceTypes.ICON.in(schema), (String)"criteria", (TypeTemplate)DSL.compoundList((TypeTemplate)PersistenceTypes.CRITERION.in(schema))));
    }

    public Map<String, Supplier<TypeTemplate>> registerEntities(Schema schema) {
        HashMap<String, Supplier<TypeTemplate>> triggers = new HashMap<String, Supplier<TypeTemplate>>();
        BingoV2.registerCriterion(triggers, "bingo:has_some_items_from_tag", () -> DSL.fields((String)"tag", (TypeTemplate)PersistenceTypes.ITEM_TAG.in(schema)));
        BingoV2.registerCriterion(triggers, "bingo:has_some_food_items", () -> DSL.and((TypeTemplate)DSL.optional((TypeTemplate)DSL.field((String)"tag", (TypeTemplate)PersistenceTypes.ITEM_TAG_PREDICATE.in(schema))), (TypeTemplate)DSL.remainder()));
        return triggers;
    }

    public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema schema) {
        HashMap<String, Supplier<TypeTemplate>> icons = new HashMap<String, Supplier<TypeTemplate>>();
        this.register(icons, "bingo:cycle_icon", () -> DSL.fields((String)"icons", (TypeTemplate)DSL.list((TypeTemplate)PersistenceTypes.ICON.in(schema))));
        this.register(icons, "bingo:indicator", () -> DSL.fields((String)"base", (TypeTemplate)PersistenceTypes.ICON.in(schema), (String)"indicator", (TypeTemplate)PersistenceTypes.ICON.in(schema)));
        this.register(icons, "bingo:item_tag_cycle", () -> DSL.fields((String)"tag", (TypeTemplate)PersistenceTypes.ITEM_TAG.in(schema)));
        return icons;
    }

    public static void registerCriterion(Map<String, Supplier<TypeTemplate>> map, String name, Supplier<TypeTemplate> template) {
        map.put(name, () -> DSL.fields((String)"conditions", (TypeTemplate)((TypeTemplate)template.get())));
    }
}

